/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.ShareTorrentDialog;
import com.frostwire.gui.bittorrent.TorrentFetcherDownload;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.iTunesMediator;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;

final class BTDownloadActions {
    static final ExploreAction EXPLORE_ACTION = new ExploreAction();
    static final ShowInLibraryAction SHOW_IN_LIBRARY_ACTION = new ShowInLibraryAction();
    static final ResumeAction RESUME_ACTION = new ResumeAction();
    static final PauseAction PAUSE_ACTION = new PauseAction();
    static final ClearInactiveAction CLEAR_INACTIVE_ACTION = new ClearInactiveAction();
    static final RetryAction RETRY_ACTION = new RetryAction();
    static final RemoveAction REMOVE_ACTION = new RemoveAction(false, false);
    static final RemoveAction REMOVE_YOUTUBE_ACTION = new RemoveYouTubeAction();
    static final RemoveAction REMOVE_TORRENT_ACTION = new RemoveAction(true, false);
    static final RemoveAction REMOVE_TORRENT_AND_DATA_ACTION = new RemoveAction(true, true);
    static final CopyMagnetAction COPY_MAGNET_ACTION = new CopyMagnetAction();
    static final CopyInfoHashAction COPY_HASH_ACTION = new CopyInfoHashAction();
    static final SendBTDownloaderAudioFilesToiTunes SEND_TO_ITUNES_ACTION = new SendBTDownloaderAudioFilesToiTunes();
    static final ShareTorrentAction SHARE_TORRENT_ACTION = new ShareTorrentAction();
    static final PlaySingleMediaFileAction PLAY_SINGLE_AUDIO_FILE_ACTION = new PlaySingleMediaFileAction();

    BTDownloadActions() {
    }

    private static class ExploreAction
    extends RefreshingAction {
        private static final long serialVersionUID = -4648558721588938475L;

        ExploreAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void performAction() {
            File toExplore;
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            if (downloaders.length > 0 && (toExplore = new File(downloaders[0].getSaveLocation(), downloaders[0].getDisplayName())) != null) {
                if (!toExplore.exists() && downloaders[0].getSaveLocation() != null && downloaders[0].getSaveLocation().isFile()) {
                    toExplore = downloaders[0].getSaveLocation();
                }
                if (toExplore.exists()) {
                    GUIMediator.launchExplorer(toExplore);
                }
            }
        }
    }

    private static class ShowInLibraryAction
    extends RefreshingAction {
        private static final long serialVersionUID = -4648558721588938475L;

        ShowInLibraryAction() {
            this.putValue("Name", I18n.tr("Show"));
            this.putValue("LimeShortName", I18n.tr("Show"));
            this.putValue("ShortDescription", I18n.tr("Shows the contents of this transfer in the Library Tab"));
            this.putValue("LimeIconName", "DOWNLOAD_SHOW_IN_LIBRARY");
        }

        @Override
        public void performAction() {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            if (downloaders.length > 0) {
                String toExplore = downloaders[0].getDisplayName();
                if (toExplore == null) {
                    return;
                }
                LibraryMediator.instance().getLibrarySearch().searchFor(toExplore.replace("_", " ").replace("-", " ").replace(".", " "), false);
            }
        }
    }

    private static class ResumeAction
    extends RefreshingAction {
        ResumeAction() {
            this.putValue("Name", I18n.tr("Resume Download"));
            this.putValue("LimeShortName", I18n.tr("Resume"));
            this.putValue("ShortDescription", I18n.tr("Reattempt Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_FILE_MORE_SOURCES");
        }

        @Override
        public void performAction() {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            BTDownload lastSelectedDownload = null;
            if (downloaders.length == 1) {
                lastSelectedDownload = downloaders[0];
            }
            TorrentUtil.askForPermissionToSeedAndSeedDownloads(downloaders);
            BTDownloadMediator.instance().updateTableFilters();
            if (lastSelectedDownload != null) {
                BTDownloadMediator.instance().selectBTDownload(lastSelectedDownload);
            }
        }
    }

    private static class PauseAction
    extends RefreshingAction {
        PauseAction() {
            this.putValue("Name", I18n.tr("Pause Download"));
            this.putValue("LimeShortName", I18n.tr("Pause"));
            this.putValue("ShortDescription", I18n.tr("Pause Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_PAUSE");
        }

        @Override
        public void performAction() {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            BTDownload lastSelectedDownload = null;
            if (downloaders.length == 1) {
                lastSelectedDownload = downloaders[0];
            }
            for (BTDownload downloader : downloaders) {
                downloader.pause();
            }
            BTDownloadMediator.instance().updateTableFilters();
            if (lastSelectedDownload != null) {
                BTDownloadMediator.instance().selectBTDownload(lastSelectedDownload);
            }
        }
    }

    private static class ClearInactiveAction
    extends RefreshingAction {
        ClearInactiveAction() {
            this.putValue("Name", I18n.tr("Clear Inactive"));
            this.putValue("LimeShortName", I18n.tr("Clear Inactive"));
            this.putValue("ShortDescription", I18n.tr("Clear Inactive (completed) transfers from the Transfers list."));
            this.putValue("LimeIconName", "DOWNLOAD_CLEAR_INACTIVE");
        }

        @Override
        protected void performAction() {
            BTDownloadMediator.instance().removeCompleted();
        }
    }

    public static class RetryAction
    extends com.limegroup.gnutella.gui.actions.AbstractAction {
        private static Logger LOG = Logger.getLogger(RetryAction.class);

        RetryAction() {
            this.putValue("Name", I18n.tr("Retry Transfer"));
            this.putValue("LimeShortName", I18n.tr("Retry Transfer"));
            this.putValue("ShortDescription", I18n.tr("Retry Transfer"));
            this.putValue("LimeIconName", "MAGNET");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            if (downloaders == null) {
                LOG.info("actionPerformed() aborted. No selected transfers to retry");
                return;
            }
            new RemoveAction(true, true, false).performAction();
            BTDownloadMediator.instance().refresh();
            for (BTDownload download : downloaders) {
                LOG.info("actionPerformed() retry " + download.getClass().getCanonicalName());
                if (!(download instanceof TorrentFetcherDownload)) continue;
                GUIMediator.instance().openTorrentURI(((TorrentFetcherDownload)download).getUri(), false);
            }
        }
    }

    public static class RemoveAction
    extends RefreshingAction {
        private final boolean _deleteTorrent;
        private final boolean _deleteData;
        private final boolean _showDialogIfDeleteData;

        RemoveAction(boolean deleteTorrent, boolean deleteData) {
            this(deleteTorrent, deleteData, true);
        }

        RemoveAction(boolean deleteTorrent, boolean deleteData, boolean showDialogIfDeleteData) {
            if (deleteTorrent && deleteData) {
                this.putValue("Name", I18n.tr("Remove Torrent and Data"));
                this.putValue("LimeShortName", I18n.tr("Remove Torrent and Data"));
                this.putValue("ShortDescription", I18n.tr("Remove Torrent and Data from selected downloads"));
            } else if (deleteTorrent) {
                this.putValue("Name", I18n.tr("Remove Torrent"));
                this.putValue("LimeShortName", I18n.tr("Remove Torrent"));
                this.putValue("ShortDescription", I18n.tr("Remove Torrent from selected downloads"));
            } else {
                this.putValue("Name", I18n.tr("Remove Download"));
                this.putValue("LimeShortName", I18n.tr("Remove"));
                this.putValue("ShortDescription", I18n.tr("Remove Selected Downloads"));
            }
            this.putValue("LimeIconName", "DOWNLOAD_KILL");
            this._deleteTorrent = deleteTorrent;
            this._deleteData = deleteData;
            this._showDialogIfDeleteData = showDialogIfDeleteData;
        }

        @Override
        public void performAction() {
            BTDownload[] downloaders;
            DialogOption result;
            if (this._deleteData && this._showDialogIfDeleteData && (result = GUIMediator.showYesNoMessage(I18n.tr("Are you sure you want to remove the data files from your computer?\n\nYou won't be able to recover the files."), I18n.tr("Are you sure?"), 3)) != DialogOption.YES) {
                return;
            }
            for (BTDownload downloader : downloaders = BTDownloadMediator.instance().getSelectedDownloaders()) {
                downloader.setDeleteTorrentWhenRemove(this._deleteTorrent);
                downloader.setDeleteDataWhenRemove(this._deleteData);
            }
            BTDownloadMediator.instance().removeSelection();
            BTDownloadMediator.instance().updateTableFilters();
        }
    }

    public static class RemoveYouTubeAction
    extends RemoveAction {
        private static final long serialVersionUID = 4101890173830827703L;

        RemoveYouTubeAction() {
            super(true, true);
            this.putValue("Name", I18n.tr("Remove Download and Data"));
            this.putValue("LimeShortName", I18n.tr("Remove Download and Data"));
            this.putValue("ShortDescription", I18n.tr("Remove Download and Data from selected downloads"));
        }
    }

    private static class CopyMagnetAction
    extends RefreshingAction {
        CopyMagnetAction() {
            this.putValue("Name", I18n.tr("Copy Magnet"));
            this.putValue("LimeShortName", I18n.tr("Copy Magnet"));
            this.putValue("ShortDescription", I18n.tr("Copy Magnet"));
            this.putValue("LimeIconName", "COPY_MAGNET");
        }

        @Override
        public void performAction() {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            StringBuilder str = new StringBuilder();
            for (int i2 = 0; i2 < downloaders.length; ++i2) {
                TorrentFetcherDownload tfd;
                BTDownload d = downloaders[i2];
                if (d instanceof BittorrentDownload) {
                    BittorrentDownload btDownload = (BittorrentDownload)d;
                    String magnetUri = btDownload.makeMagnetUri();
                    str.append(magnetUri);
                    str.append(BTEngine.getInstance().magnetPeers());
                    if (i2 >= downloaders.length - 1) continue;
                    str.append(System.lineSeparator());
                    continue;
                }
                if (!(d instanceof TorrentFetcherDownload) || !(tfd = (TorrentFetcherDownload)d).getUri().startsWith("magnet")) continue;
                str = new StringBuilder(tfd.getUri());
            }
            GUIMediator.setClipboardContent(str.toString());
        }
    }

    private static class CopyInfoHashAction
    extends RefreshingAction {
        CopyInfoHashAction() {
            this.putValue("Name", I18n.tr("Copy Infohash"));
            this.putValue("LimeShortName", I18n.tr("Copy Infohash"));
            this.putValue("ShortDescription", I18n.tr("Copy Infohash"));
            this.putValue("LimeIconName", "COPY_HASH");
        }

        @Override
        public void performAction() {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            StringBuilder str = new StringBuilder();
            for (int i2 = 0; i2 < downloaders.length; ++i2) {
                str.append(downloaders[i2].getHash());
                if (i2 >= downloaders.length - 1) continue;
                str.append("\n");
            }
            GUIMediator.setClipboardContent(str.toString());
        }
    }

    private static class SendBTDownloaderAudioFilesToiTunes
    extends AbstractAction {
        SendBTDownloaderAudioFilesToiTunes() {
            this.putValue("Name", I18n.tr("Send to iTunes"));
            this.putValue("ShortDescription", I18n.tr("Send files to iTunes"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            if (downloaders != null && downloaders.length > 0) {
                try {
                    BTDownload downloader = downloaders[0];
                    File saveLocation = downloader.getSaveLocation();
                    if (downloader instanceof BittorrentDownload) {
                        BittorrentDownload btDownload = (BittorrentDownload)downloader;
                        saveLocation = new File(btDownload.getSaveLocation(), btDownload.getName());
                    }
                    System.out.println("Sending to iTunes " + saveLocation.getAbsolutePath());
                    iTunesMediator.instance().scanForSongs(saveLocation);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static class ShareTorrentAction
    extends RefreshingAction {
        ShareTorrentAction() {
            this.putValue("Name", I18n.tr("Send to friend"));
            this.putValue("LimeShortName", I18n.tr("Send to friend"));
            this.putValue("ShortDescription", I18n.tr("Send to friend"));
            this.putValue("LimeIconName", "SEND_HASH");
        }

        @Override
        public void performAction() {
            TorrentInfo t;
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            if (downloaders.length != 1) {
                return;
            }
            BTDownload btDownload = downloaders[0];
            if (btDownload instanceof BittorrentDownload && (t = ((BittorrentDownload)btDownload).getTorrentInfo()) != null) {
                new ShareTorrentDialog(GUIMediator.getAppFrame(), t).setVisible(true);
            }
        }
    }

    static final class PlaySingleMediaFileAction
    extends AbstractAction {
        PlaySingleMediaFileAction() {
            super(I18n.tr("Play file"));
            this.putValue("LongDescription", I18n.tr("Play media file"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = BTDownloadMediator.instance().getSelectedDownloaders()[0].getSaveLocation();
            if (file.isDirectory() && LibraryUtils.directoryContainsASinglePlayableFile(file)) {
                try {
                    file = file.listFiles()[0];
                }
                catch (Throwable t) {
                    file = null;
                }
            }
            if (file != null && MediaPlayer.isPlayableFile(file)) {
                MediaPlayer.instance().loadMedia(new MediaSource(file), false, false);
            }
        }
    }

    private static abstract class RefreshingAction
    extends AbstractAction {
        private RefreshingAction() {
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.performAction();
            BTDownloadMediator.instance().doRefresh();
        }

        protected abstract void performAction();
    }
}

