/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.database.sqlite;

import com.frostwire.database.Cursor;
import com.frostwire.database.sqlite.SQLiteDatabase;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SQLiteQueryBuilder {
    private static final Pattern sLimitPattern = Pattern.compile("\\s*\\d+\\s*(,\\s*\\d+\\s*)?");
    private final Map<String, String> mProjectionMap = null;
    private String mTables = "";
    private final StringBuilder mWhereClause = null;
    private final boolean mDistinct;
    private boolean mStrict;

    public SQLiteQueryBuilder() {
        this.mDistinct = false;
    }

    private static String buildQueryString(boolean distinct2, String tables, String[] columns, String where, String groupBy, String having, String orderBy, String limit) {
        if (StringUtils.isEmpty(groupBy) && !StringUtils.isEmpty(having)) {
            throw new IllegalArgumentException("HAVING clauses are only permitted when using a groupBy clause");
        }
        if (!StringUtils.isEmpty(limit) && !sLimitPattern.matcher(limit).matches()) {
            throw new IllegalArgumentException("invalid LIMIT clauses:" + limit);
        }
        StringBuilder query = new StringBuilder(120);
        query.append("SELECT ");
        if (distinct2) {
            query.append("DISTINCT ");
        }
        if (columns != null && columns.length != 0) {
            SQLiteQueryBuilder.appendColumns(query, columns);
        } else {
            query.append("* ");
        }
        query.append("FROM ");
        query.append(tables);
        SQLiteQueryBuilder.appendClause(query, " WHERE ", where);
        SQLiteQueryBuilder.appendClause(query, " GROUP BY ", groupBy);
        SQLiteQueryBuilder.appendClause(query, " HAVING ", having);
        SQLiteQueryBuilder.appendClause(query, " ORDER BY ", orderBy);
        SQLiteQueryBuilder.appendClause(query, " LIMIT ", limit);
        return query.toString();
    }

    private static void appendClause(StringBuilder s, String name, String clause) {
        if (!StringUtils.isEmpty(clause)) {
            s.append(name);
            s.append(clause);
        }
    }

    private static void appendColumns(StringBuilder s, String[] columns) {
        int n = columns.length;
        for (int i2 = 0; i2 < n; ++i2) {
            String column = columns[i2];
            if (column == null) continue;
            if (i2 > 0) {
                s.append(", ");
            }
            s.append(column);
        }
        s.append(' ');
    }

    public String getTables() {
        return this.mTables;
    }

    public void setTables(String inTables) {
        this.mTables = inTables;
    }

    public void setStrict(boolean flag) {
        this.mStrict = flag;
    }

    public Cursor query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder) {
        return this.query(db, projectionIn, selection, selectionArgs, groupBy, having, sortOrder, null);
    }

    private Cursor query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit) {
        if (this.mTables == null) {
            return null;
        }
        String sql = this.buildQuery(projectionIn, selection, groupBy, having, sortOrder, limit);
        return db.rawQueryWithFactory(sql, selectionArgs);
    }

    private String buildQuery(String[] projectionIn, String selection, String groupBy, String having, String sortOrder, String limit) {
        boolean hasBaseWhereClause;
        String[] projection = this.computeProjection(projectionIn);
        StringBuilder where = new StringBuilder();
        boolean bl = hasBaseWhereClause = this.mWhereClause != null && this.mWhereClause.length() > 0;
        if (hasBaseWhereClause) {
            where.append(this.mWhereClause.toString());
            where.append(')');
        }
        if (selection != null && selection.length() > 0) {
            if (hasBaseWhereClause) {
                where.append(" AND ");
            }
            where.append('(');
            where.append(selection);
            where.append(')');
        }
        return SQLiteQueryBuilder.buildQueryString(this.mDistinct, this.mTables, projection, where.toString(), groupBy, having, sortOrder, limit);
    }

    @Deprecated
    public String buildQuery(String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit) {
        return this.buildQuery(projectionIn, selection, groupBy, having, sortOrder, limit);
    }

    private String[] computeProjection(String[] projectionIn) {
        if (projectionIn != null && projectionIn.length > 0) {
            if (this.mProjectionMap != null) {
                String[] projection = new String[projectionIn.length];
                int length = projectionIn.length;
                for (int i2 = 0; i2 < length; ++i2) {
                    String userColumn = projectionIn[i2];
                    String column = this.mProjectionMap.get(userColumn);
                    if (column != null) {
                        projection[i2] = column;
                        continue;
                    }
                    if (!this.mStrict && (userColumn.contains(" AS ") || userColumn.contains(" as "))) {
                        projection[i2] = userColumn;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid column " + projectionIn[i2]);
                }
                return projection;
            }
            return projectionIn;
        }
        if (this.mProjectionMap != null) {
            Set<Map.Entry<String, String>> entrySet = this.mProjectionMap.entrySet();
            String[] projection = new String[entrySet.size()];
            Iterator<Map.Entry<String, String>> entryIter = entrySet.iterator();
            int i3 = 0;
            while (entryIter.hasNext()) {
                Map.Entry<String, String> entry2 = entryIter.next();
                projection[i3++] = entry2.getValue();
            }
            return projection;
        }
        return null;
    }
}

