/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.database.sqlite;

import com.frostwire.content.ContentValues;
import com.frostwire.database.Cursor;
import com.frostwire.database.SQLException;
import com.frostwire.util.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class SQLiteDatabase {
    private static final Logger LOG = Logger.getLogger(SQLiteDatabase.class);
    private final Connection connection;
    private final AtomicBoolean open = new AtomicBoolean(false);
    private String path;

    SQLiteDatabase(String path, Connection connection) {
        this.path = path;
        this.connection = connection;
        this.open.set(true);
    }

    private String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Cursor rawQueryWithFactory(String sql, String[] selectionArgs) {
        this.verifyDbIsOpen();
        Cursor cursor = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                statement = this.prepareStatement(this.connection, sql, selectionArgs);
                resultSet = statement.executeQuery();
                return new Cursor(statement, resultSet);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error performing SQL statement: " + sql, e);
            return cursor;
        }
    }

    public void execSQL(String sql) throws SQLException {
        this.executeSql(sql, null);
    }

    public long insert(String table, String nullColumnHack, ContentValues values2) {
        int size;
        this.verifyDbIsOpen();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT");
        sql.append(" INTO ");
        sql.append(table);
        sql.append(" (");
        Object[] bindArgs = null;
        int n = size = values2 != null && values2.size() > 0 ? values2.size() : 0;
        if (size > 0) {
            bindArgs = new Object[size];
            int i2 = 0;
            for (String colName : values2.keySet()) {
                sql.append(i2 > 0 ? "," : "");
                sql.append(colName);
                bindArgs[i2++] = values2.get(colName);
            }
            sql.append(')');
            sql.append(" VALUES (");
            for (i2 = 0; i2 < size; ++i2) {
                sql.append(i2 > 0 ? ",?" : "?");
            }
        } else {
            sql.append(nullColumnHack).append(") VALUES (NULL");
        }
        sql.append(')');
        return this.executeSql(sql.toString(), bindArgs);
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        this.verifyDbIsOpen();
        String sql = "DELETE FROM " + table + (String)(!StringUtils.isEmpty(whereClause) ? " WHERE " + whereClause : "");
        return this.executeSql(sql, whereArgs);
    }

    public int update(String table, ContentValues values2, String whereClause, String[] whereArgs) {
        this.verifyDbIsOpen();
        if (values2 == null || values2.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        StringBuilder sql = new StringBuilder(120);
        sql.append("UPDATE ");
        sql.append(table);
        sql.append(" SET ");
        int setValuesSize = values2.size();
        int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
        Object[] bindArgs = new Object[bindArgsSize];
        int i2 = 0;
        for (String colName : values2.keySet()) {
            sql.append(i2 > 0 ? "," : "");
            sql.append(colName);
            bindArgs[i2++] = values2.get(colName);
            sql.append("=?");
        }
        if (whereArgs != null) {
            for (i2 = setValuesSize; i2 < bindArgsSize; ++i2) {
                bindArgs[i2] = whereArgs[i2 - setValuesSize];
            }
        }
        if (!StringUtils.isEmpty(whereClause)) {
            sql.append(" WHERE ");
            sql.append(whereClause);
        }
        return this.executeSql(sql.toString(), bindArgs);
    }

    private boolean isOpen() {
        return this.open.get();
    }

    public void close() {
        if (this.open.compareAndSet(true, false)) {
            try {
                Statement statement = this.connection.createStatement();
                statement.execute("SHUTDOWN");
                this.connection.close();
            }
            catch (Throwable e) {
                LOG.warn("Error closing the smart search database", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int executeSql(String sql, Object[] bindArgs) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void verifyDbIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("database " + this.getPath() + " already closed");
        }
    }

    private PreparedStatement prepareStatement(Connection connection, String sql, Object ... arguments) throws Exception {
        PreparedStatement statement = connection.prepareStatement(sql, 1003, 1007);
        if (arguments != null) {
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                statement.setObject(i2 + 1, arguments[i2]);
            }
        }
        return statement;
    }
}

