/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.database;

import com.frostwire.util.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Cursor {
    private static final Logger LOG = Logger.getLogger(Cursor.class);
    private final Statement statement;
    private final ResultSet rs;

    public Cursor(Statement statement, ResultSet rs) {
        this.statement = statement;
        this.rs = rs;
    }

    public int getInt(int columnIndex) {
        try {
            return this.rs.getInt(columnIndex);
        }
        catch (SQLException e) {
            LOG.warn("Error reading typed result set value", e);
            return 0;
        }
    }

    public String getString(int columnIndex) {
        try {
            return this.rs.getString(columnIndex);
        }
        catch (SQLException e) {
            LOG.warn("Error reading typed result set value", e);
            return null;
        }
    }

    public long getLong(int columnIndex) {
        try {
            return this.rs.getLong(columnIndex);
        }
        catch (SQLException e) {
            LOG.warn("Error reading typed result set value", e);
            return 0L;
        }
    }

    public int getColumnIndex(String columnName) {
        try {
            return this.rs.findColumn(columnName);
        }
        catch (SQLException sQLException) {
            return -1;
        }
    }

    public int getCount() {
        try {
            this.rs.next();
            return this.rs.getRow();
        }
        catch (SQLException e) {
            LOG.warn("Error getting result set size", e);
            return 0;
        }
    }

    public void close() {
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            LOG.warn("Error closing cursor result set", e);
        }
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            LOG.warn("Error closing cursor inner statement", e);
        }
    }

    public boolean moveToPosition(int offset) {
        try {
            return this.rs.relative(offset);
        }
        catch (SQLException e) {
            LOG.warn("Error moving inside the result set, offset: " + offset, e);
            return false;
        }
    }

    public boolean moveToNext() {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            LOG.warn("Error moving inside the result set, to next", e);
            return false;
        }
    }

    public byte getByte(int columnIndex) {
        try {
            return this.rs.getByte(columnIndex);
        }
        catch (SQLException e) {
            LOG.warn("Error reading typed result set value", e);
            return 0;
        }
    }

    public boolean getBoolean(int columnIndex) {
        try {
            return this.rs.getBoolean(columnIndex);
        }
        catch (SQLException e) {
            LOG.warn("Error reading typed result set value", e);
            return false;
        }
    }

    public byte[] getBytes(int columnIndex) {
        try {
            return this.rs.getBytes(columnIndex);
        }
        catch (SQLException e) {
            LOG.warn("Error reading typed result set value", e);
            return null;
        }
    }
}

