/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.concurrent.concurrent;

import com.frostwire.concurrent.concurrent.ExecutorsHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

public class ThreadExecutor {
    private static final ThreadFactory FACTORY = ExecutorsHelper.daemonThreadFactory("ThreadExecutor.FACTORY");
    private static final ExecutorService THREAD_POOL = ExecutorsHelper.newThreadPool(FACTORY);

    public static Thread newManagedThread(Runnable r) {
        return FACTORY.newThread(r);
    }

    public static Thread newManagedThread(Runnable r, String name) {
        Thread thread2 = ThreadExecutor.newManagedThread(r);
        thread2.setName(name);
        return thread2;
    }

    public static void startThread(Runnable runner, String name) {
        THREAD_POOL.execute(() -> {
            try {
                Thread.currentThread().setName(name);
                runner.run();
            }
            catch (Throwable t) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), t);
            }
            finally {
                Thread.currentThread().setName("IdleThread");
            }
        });
    }
}

