/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.concurrent.concurrent;

import com.frostwire.concurrent.concurrent.ManagedThread;
import com.frostwire.concurrent.concurrent.ThreadPoolExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExecutorsHelper {
    public static ExecutorService newProcessingQueue(String name) {
        return ExecutorsHelper.newProcessingQueue(ExecutorsHelper.daemonThreadFactory(name));
    }

    public static ExecutorService newProcessingQueue(ThreadFactory factory2) {
        return Executors.unconfigurableExecutorService(ExecutorsHelper.newSingleThreadExecutor(factory2));
    }

    private static java.util.concurrent.ThreadPoolExecutor newSingleThreadExecutor(ThreadFactory factory2) {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory2);
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    static ExecutorService newThreadPool(ThreadFactory factory2) {
        return Executors.unconfigurableExecutorService(new ThreadPoolExecutor(0, 64, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory2));
    }

    public static ExecutorService newFixedSizeThreadPool(int size, String name) {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(size, size, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorsHelper.daemonThreadFactory(name));
        tpe.allowCoreThreadTimeOut(true);
        return Executors.unconfigurableExecutorService(tpe);
    }

    static ThreadFactory daemonThreadFactory(String name) {
        return new DefaultThreadFactory(name, true);
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private final String name;
        private final boolean daemon;

        DefaultThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            ManagedThread t = new ManagedThread(r, this.name);
            if (this.daemon) {
                t.setDaemon(true);
            }
            return t;
        }
    }
}

