/*
 * Decompiled with CFR 0.152.
 */
package com.apple.concurrent;

import com.apple.concurrent.LibDispatchNative;
import com.apple.concurrent.LibDispatchQueue;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;

class LibDispatchSerialQueue
extends AbstractExecutorService {
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int TERMINATED = 3;
    private final Object lock = new Object();
    private LibDispatchQueue nativeQueueWrapper;
    private volatile int runState;

    LibDispatchSerialQueue(long queuePtr) {
        this.nativeQueueWrapper = new LibDispatchQueue(queuePtr);
    }

    @Override
    public void execute(Runnable task) {
        if (this.nativeQueueWrapper == null) {
            return;
        }
        LibDispatchNative.nativeExecuteAsync(this.nativeQueueWrapper.ptr, task);
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.runState != 0) {
                return;
            }
            this.runState = 1;
            this.execute(() -> {
                Object object = this.lock;
                synchronized (object) {
                    this.runState = 3;
                    this.lock.notifyAll();
                }
            });
            this.nativeQueueWrapper = null;
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
        if (this.runState == 3) {
            return true;
        }
        long millis = unit.toMillis(timeout2);
        if (millis <= 0L) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.runState == 3) {
                return true;
            }
            this.lock.wait(timeout2);
            if (this.runState == 3) {
                return true;
            }
        }
        return false;
    }
}

