/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.asf;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.asf.AsfFieldKey;
import org.jaudiotagger.tag.asf.AsfTagCoverField;
import org.jaudiotagger.tag.asf.AsfTagField;
import org.jaudiotagger.tag.asf.AsfTagTextField;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.reference.PictureTypes;

public final class AsfTag
extends AbstractTag {
    public static final Set<AsfFieldKey> COMMON_FIELDS;
    private static final EnumMap<FieldKey, AsfFieldKey> tagFieldToAsfField;
    private final boolean copyFields;

    public AsfTag() {
        this(false);
    }

    public AsfTag(boolean copy) {
        this.copyFields = copy;
    }

    public AsfTag(Tag source, boolean copy) throws UnsupportedEncodingException {
        this(copy);
        this.copyFrom(source);
    }

    @Override
    public void addField(TagField field) {
        if (this.isValidField(field)) {
            if (AsfFieldKey.isMultiValued(field.getId())) {
                super.addField(this.copyFrom(field));
            } else {
                super.setField(this.copyFrom(field));
            }
        }
    }

    public void addCopyright(String copyRight) {
        this.addField(this.createCopyrightField(copyRight));
    }

    public void addRating(String rating) {
        this.addField(this.createRatingField(rating));
    }

    private void copyFrom(Tag source) {
        Iterator<TagField> fieldIterator = source.getFields();
        while (fieldIterator.hasNext()) {
            TagField copy = this.copyFrom(fieldIterator.next());
            if (copy == null) continue;
            super.addField(copy);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TagField copyFrom(TagField source) {
        if (!this.isCopyingFields()) return source;
        if (source instanceof AsfTagField) {
            try {
                return (TagField)((AsfTagField)source).clone();
            }
            catch (CloneNotSupportedException e) {
                return new AsfTagField(((AsfTagField)source).getDescriptor());
            }
        }
        if (!(source instanceof TagTextField)) throw new RuntimeException("Unknown Asf Tag Field class:" + source.getClass());
        String content = ((TagTextField)source).getContent();
        return new AsfTagTextField(source.getId(), content);
    }

    @Override
    public AsfTagCoverField createField(Artwork artwork) {
        return new AsfTagCoverField(artwork.getBinaryData(), artwork.getPictureType(), artwork.getDescription(), artwork.getMimeType());
    }

    public AsfTagCoverField createArtworkField(byte[] data) {
        return new AsfTagCoverField(data, PictureTypes.DEFAULT_ID, null, null);
    }

    public AsfTagTextField createCopyrightField(String content) {
        return new AsfTagTextField(AsfFieldKey.COPYRIGHT, content);
    }

    public AsfTagTextField createRatingField(String content) {
        return new AsfTagTextField(AsfFieldKey.RATING, content);
    }

    public AsfTagTextField createField(AsfFieldKey asfFieldKey, String value) {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (asfFieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        switch (asfFieldKey) {
            case COVER_ART: {
                throw new UnsupportedOperationException("Cover Art cannot be created using this method");
            }
            case BANNER_IMAGE: {
                throw new UnsupportedOperationException("Banner Image cannot be created using this method");
            }
        }
        return new AsfTagTextField(asfFieldKey.getFieldName(), value);
    }

    @Override
    public AsfTagTextField createField(FieldKey genericKey, String ... values) throws KeyNotFoundException, FieldDataInvalidException {
        if (values == null || values[0] == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (genericKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        AsfFieldKey asfFieldKey = tagFieldToAsfField.get((Object)genericKey);
        if (asfFieldKey == null) {
            throw new KeyNotFoundException(genericKey.toString());
        }
        return this.createField(asfFieldKey, values[0]);
    }

    public void deleteField(AsfFieldKey fieldKey) {
        super.deleteField(fieldKey.getFieldName());
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(tagFieldToAsfField.get((Object)fieldKey).getFieldName());
    }

    @Override
    public List<TagField> getFields(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        AsfFieldKey asfKey = tagFieldToAsfField.get((Object)fieldKey);
        if (asfKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFields(asfKey.getFieldName());
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        AsfFieldKey asfFieldKey = tagFieldToAsfField.get((Object)genericKey);
        if (asfFieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getAll(asfFieldKey.getFieldName());
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> coverartList = this.getFields(FieldKey.COVER_ART);
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(coverartList.size());
        for (TagField next : coverartList) {
            AsfTagCoverField coverArt = (AsfTagCoverField)next;
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setBinaryData(coverArt.getRawImageData());
            artwork.setMimeType(coverArt.getMimeType());
            artwork.setDescription(coverArt.getDescription());
            artwork.setPictureType(coverArt.getPictureType());
            artworkList.add(artwork);
        }
        return artworkList;
    }

    public Iterator<AsfTagField> getAsfFields() {
        if (!this.isCopyingFields()) {
            throw new IllegalStateException("Since the field conversion is not enabled, this method cannot be executed");
        }
        return new AsfFieldIterator(this.getFields());
    }

    public List<TagField> getCopyright() {
        return this.getFields(AsfFieldKey.COPYRIGHT.getFieldName());
    }

    @Override
    public String getFirst(FieldKey genericKey) throws KeyNotFoundException {
        return this.getValue(genericKey, 0);
    }

    public String getFirst(AsfFieldKey asfKey) throws KeyNotFoundException {
        if (asfKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(asfKey.getFieldName());
    }

    @Override
    public String getValue(FieldKey genericKey, int index) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getItem(tagFieldToAsfField.get((Object)genericKey).getFieldName(), index);
    }

    public String getFirstCopyright() {
        return this.getFirst(AsfFieldKey.COPYRIGHT.getFieldName());
    }

    @Override
    public AsfTagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return (AsfTagField)super.getFirstField(tagFieldToAsfField.get((Object)genericKey).getFieldName());
    }

    public String getFirstRating() {
        return this.getFirst(AsfFieldKey.RATING.getFieldName());
    }

    public List<TagField> getRating() {
        return this.getFields(AsfFieldKey.RATING.getFieldName());
    }

    @Override
    protected boolean isAllowedEncoding(Charset enc) {
        return AsfHeader.ASF_CHARSET.name().equals(enc);
    }

    public boolean isCopyingFields() {
        return this.copyFields;
    }

    private boolean isValidField(TagField field) {
        if (field == null) {
            return false;
        }
        if (!(field instanceof AsfTagField)) {
            return false;
        }
        return !field.isEmpty();
    }

    @Override
    public void setField(TagField field) {
        if (this.isValidField(field)) {
            super.setField(this.copyFrom(field));
        }
    }

    public void setCopyright(String Copyright) {
        this.setField(this.createCopyrightField(Copyright));
    }

    public void setRating(String rating) {
        this.setField(this.createRatingField(rating));
    }

    @Override
    public boolean hasField(FieldKey genericKey) {
        AsfFieldKey mp4FieldKey = tagFieldToAsfField.get((Object)genericKey);
        return this.getFields(mp4FieldKey.getFieldName()).size() != 0;
    }

    public boolean hasField(AsfFieldKey asfFieldKey) {
        return this.getFields(asfFieldKey.getFieldName()).size() != 0;
    }

    @Override
    public TagField createCompilationField(boolean value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.createField(FieldKey.IS_COMPILATION, String.valueOf(value));
    }

    static {
        tagFieldToAsfField = new EnumMap(FieldKey.class);
        tagFieldToAsfField.put(FieldKey.ACOUSTID_FINGERPRINT, AsfFieldKey.ACOUSTID_FINGERPRINT);
        tagFieldToAsfField.put(FieldKey.ACOUSTID_ID, AsfFieldKey.ACOUSTID_ID);
        tagFieldToAsfField.put(FieldKey.ALBUM, AsfFieldKey.ALBUM);
        tagFieldToAsfField.put(FieldKey.ALBUM_ARTIST, AsfFieldKey.ALBUM_ARTIST);
        tagFieldToAsfField.put(FieldKey.ALBUM_ARTIST_SORT, AsfFieldKey.ALBUM_ARTIST_SORT);
        tagFieldToAsfField.put(FieldKey.ALBUM_ARTISTS, AsfFieldKey.ALBUM_ARTISTS);
        tagFieldToAsfField.put(FieldKey.ALBUM_ARTISTS_SORT, AsfFieldKey.ALBUM_ARTISTS_SORT);
        tagFieldToAsfField.put(FieldKey.ALBUM_SORT, AsfFieldKey.ALBUM_SORT);
        tagFieldToAsfField.put(FieldKey.AMAZON_ID, AsfFieldKey.AMAZON_ID);
        tagFieldToAsfField.put(FieldKey.ARRANGER, AsfFieldKey.ARRANGER);
        tagFieldToAsfField.put(FieldKey.ARRANGER_SORT, AsfFieldKey.ARRANGER_SORT);
        tagFieldToAsfField.put(FieldKey.ARTIST, AsfFieldKey.AUTHOR);
        tagFieldToAsfField.put(FieldKey.ARTISTS, AsfFieldKey.ARTISTS);
        tagFieldToAsfField.put(FieldKey.ARTISTS_SORT, AsfFieldKey.ARTISTS_SORT);
        tagFieldToAsfField.put(FieldKey.ARTIST_SORT, AsfFieldKey.ARTIST_SORT);
        tagFieldToAsfField.put(FieldKey.BARCODE, AsfFieldKey.BARCODE);
        tagFieldToAsfField.put(FieldKey.BPM, AsfFieldKey.BPM);
        tagFieldToAsfField.put(FieldKey.CATALOG_NO, AsfFieldKey.CATALOG_NO);
        tagFieldToAsfField.put(FieldKey.CHOIR, AsfFieldKey.CHOIR);
        tagFieldToAsfField.put(FieldKey.CHOIR_SORT, AsfFieldKey.CHOIR_SORT);
        tagFieldToAsfField.put(FieldKey.CLASSICAL_CATALOG, AsfFieldKey.CLASSICAL_CATALOG);
        tagFieldToAsfField.put(FieldKey.CLASSICAL_NICKNAME, AsfFieldKey.CLASSICAL_NICKNAME);
        tagFieldToAsfField.put(FieldKey.COMMENT, AsfFieldKey.DESCRIPTION);
        tagFieldToAsfField.put(FieldKey.COMPOSER, AsfFieldKey.COMPOSER);
        tagFieldToAsfField.put(FieldKey.COMPOSER_SORT, AsfFieldKey.COMPOSER_SORT);
        tagFieldToAsfField.put(FieldKey.CONDUCTOR, AsfFieldKey.CONDUCTOR);
        tagFieldToAsfField.put(FieldKey.CONDUCTOR_SORT, AsfFieldKey.CONDUCTOR_SORT);
        tagFieldToAsfField.put(FieldKey.COPYRIGHT, AsfFieldKey.COPYRIGHT);
        tagFieldToAsfField.put(FieldKey.COUNTRY, AsfFieldKey.COUNTRY);
        tagFieldToAsfField.put(FieldKey.COVER_ART, AsfFieldKey.COVER_ART);
        tagFieldToAsfField.put(FieldKey.CUSTOM1, AsfFieldKey.CUSTOM1);
        tagFieldToAsfField.put(FieldKey.CUSTOM2, AsfFieldKey.CUSTOM2);
        tagFieldToAsfField.put(FieldKey.CUSTOM3, AsfFieldKey.CUSTOM3);
        tagFieldToAsfField.put(FieldKey.CUSTOM4, AsfFieldKey.CUSTOM4);
        tagFieldToAsfField.put(FieldKey.CUSTOM5, AsfFieldKey.CUSTOM5);
        tagFieldToAsfField.put(FieldKey.DISC_NO, AsfFieldKey.DISC_NO);
        tagFieldToAsfField.put(FieldKey.DISC_SUBTITLE, AsfFieldKey.DISC_SUBTITLE);
        tagFieldToAsfField.put(FieldKey.DISC_TOTAL, AsfFieldKey.DISC_TOTAL);
        tagFieldToAsfField.put(FieldKey.DJMIXER, AsfFieldKey.DJMIXER);
        tagFieldToAsfField.put(FieldKey.MOOD_ELECTRONIC, AsfFieldKey.MOOD_ELECTRONIC);
        tagFieldToAsfField.put(FieldKey.ENCODER, AsfFieldKey.ENCODER);
        tagFieldToAsfField.put(FieldKey.ENGINEER, AsfFieldKey.ENGINEER);
        tagFieldToAsfField.put(FieldKey.ENSEMBLE, AsfFieldKey.ENSEMBLE);
        tagFieldToAsfField.put(FieldKey.ENSEMBLE_SORT, AsfFieldKey.ENSEMBLE_SORT);
        tagFieldToAsfField.put(FieldKey.FBPM, AsfFieldKey.FBPM);
        tagFieldToAsfField.put(FieldKey.GENRE, AsfFieldKey.GENRE);
        tagFieldToAsfField.put(FieldKey.GROUP, AsfFieldKey.GROUP);
        tagFieldToAsfField.put(FieldKey.GROUPING, AsfFieldKey.GROUPING);
        tagFieldToAsfField.put(FieldKey.INSTRUMENT, AsfFieldKey.INSTRUMENT);
        tagFieldToAsfField.put(FieldKey.INVOLVED_PERSON, AsfFieldKey.INVOLVED_PERSON);
        tagFieldToAsfField.put(FieldKey.IPI, AsfFieldKey.IPI);
        tagFieldToAsfField.put(FieldKey.ISRC, AsfFieldKey.ISRC);
        tagFieldToAsfField.put(FieldKey.ISWC, AsfFieldKey.ISWC);
        tagFieldToAsfField.put(FieldKey.IS_CLASSICAL, AsfFieldKey.IS_CLASSICAL);
        tagFieldToAsfField.put(FieldKey.IS_COMPILATION, AsfFieldKey.IS_COMPILATION);
        tagFieldToAsfField.put(FieldKey.IS_GREATEST_HITS, AsfFieldKey.IS_GREATEST_HITS);
        tagFieldToAsfField.put(FieldKey.IS_HD, AsfFieldKey.IS_HD);
        tagFieldToAsfField.put(FieldKey.IS_SOUNDTRACK, AsfFieldKey.IS_SOUNDTRACK);
        tagFieldToAsfField.put(FieldKey.KEY, AsfFieldKey.INITIAL_KEY);
        tagFieldToAsfField.put(FieldKey.LANGUAGE, AsfFieldKey.LANGUAGE);
        tagFieldToAsfField.put(FieldKey.LYRICIST, AsfFieldKey.LYRICIST);
        tagFieldToAsfField.put(FieldKey.LYRICIST_SORT, AsfFieldKey.LYRICIST_SORT);
        tagFieldToAsfField.put(FieldKey.LYRICS, AsfFieldKey.LYRICS);
        tagFieldToAsfField.put(FieldKey.MEDIA, AsfFieldKey.MEDIA);
        tagFieldToAsfField.put(FieldKey.MIXER, AsfFieldKey.MIXER);
        tagFieldToAsfField.put(FieldKey.MOOD, AsfFieldKey.MOOD);
        tagFieldToAsfField.put(FieldKey.MOOD_ACOUSTIC, AsfFieldKey.MOOD_ACOUSTIC);
        tagFieldToAsfField.put(FieldKey.MOOD_AGGRESSIVE, AsfFieldKey.MOOD_AGGRESSIVE);
        tagFieldToAsfField.put(FieldKey.MOOD_AROUSAL, AsfFieldKey.MOOD_AROUSAL);
        tagFieldToAsfField.put(FieldKey.MOOD_DANCEABILITY, AsfFieldKey.MOOD_DANCEABILITY);
        tagFieldToAsfField.put(FieldKey.MOOD_HAPPY, AsfFieldKey.MOOD_HAPPY);
        tagFieldToAsfField.put(FieldKey.MOOD_INSTRUMENTAL, AsfFieldKey.MOOD_INSTRUMENTAL);
        tagFieldToAsfField.put(FieldKey.MOOD_PARTY, AsfFieldKey.MOOD_PARTY);
        tagFieldToAsfField.put(FieldKey.MOOD_RELAXED, AsfFieldKey.MOOD_RELAXED);
        tagFieldToAsfField.put(FieldKey.MOOD_SAD, AsfFieldKey.MOOD_SAD);
        tagFieldToAsfField.put(FieldKey.MOOD_VALENCE, AsfFieldKey.MOOD_VALENCE);
        tagFieldToAsfField.put(FieldKey.MOVEMENT, AsfFieldKey.MOVEMENT);
        tagFieldToAsfField.put(FieldKey.MOVEMENT_NO, AsfFieldKey.MOVEMENT_NO);
        tagFieldToAsfField.put(FieldKey.MOVEMENT_TOTAL, AsfFieldKey.MOVEMENT_TOTAL);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_ARTISTID, AsfFieldKey.MUSICBRAINZ_ARTISTID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_DISC_ID, AsfFieldKey.MUSICBRAINZ_DISC_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_ORIGINAL_RELEASE_ID, AsfFieldKey.MUSICBRAINZ_ORIGINAL_RELEASEID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASEARTISTID, AsfFieldKey.MUSICBRAINZ_RELEASEARTISTID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASEID, AsfFieldKey.MUSICBRAINZ_RELEASEID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASE_COUNTRY, AsfFieldKey.MUSICBRAINZ_RELEASE_COUNTRY);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASE_GROUP_ID, AsfFieldKey.MUSICBRAINZ_RELEASEGROUPID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASE_STATUS, AsfFieldKey.MUSICBRAINZ_RELEASE_STATUS);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASE_TRACK_ID, AsfFieldKey.MUSICBRAINZ_RELEASETRACKID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RELEASE_TYPE, AsfFieldKey.MUSICBRAINZ_RELEASE_TYPE);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_TRACK_ID, AsfFieldKey.MUSICBRAINZ_TRACK_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK, AsfFieldKey.MUSICBRAINZ_WORK);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_ID, AsfFieldKey.MUSICBRAINZ_WORKID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RECORDING_WORK, AsfFieldKey.MUSICBRAINZ_RECORDING_WORK);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_RECORDING_WORK_ID, AsfFieldKey.MUSICBRAINZ_RECORDING_WORK_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL1);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_ID, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_TYPE, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL1_TYPE);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL2);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_ID, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_TYPE, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL2_TYPE);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL3);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_ID, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_TYPE, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL3_TYPE);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL4);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_ID, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_TYPE, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL4_TYPE);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL5);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_ID, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_TYPE, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL5_TYPE);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL6);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_ID, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_ID);
        tagFieldToAsfField.put(FieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_TYPE, AsfFieldKey.MUSICBRAINZ_WORK_PART_LEVEL6_TYPE);
        tagFieldToAsfField.put(FieldKey.MUSICIP_ID, AsfFieldKey.MUSICIP_ID);
        tagFieldToAsfField.put(FieldKey.OCCASION, AsfFieldKey.OCCASION);
        tagFieldToAsfField.put(FieldKey.OPUS, AsfFieldKey.OPUS);
        tagFieldToAsfField.put(FieldKey.ORCHESTRA, AsfFieldKey.ORCHESTRA);
        tagFieldToAsfField.put(FieldKey.ORCHESTRA_SORT, AsfFieldKey.ORCHESTRA_SORT);
        tagFieldToAsfField.put(FieldKey.ORIGINAL_ALBUM, AsfFieldKey.ORIGINAL_ALBUM);
        tagFieldToAsfField.put(FieldKey.ORIGINAL_ARTIST, AsfFieldKey.ORIGINAL_ARTIST);
        tagFieldToAsfField.put(FieldKey.ORIGINAL_LYRICIST, AsfFieldKey.ORIGINAL_LYRICIST);
        tagFieldToAsfField.put(FieldKey.ORIGINAL_YEAR, AsfFieldKey.ORIGINAL_YEAR);
        tagFieldToAsfField.put(FieldKey.OVERALL_WORK, AsfFieldKey.OVERALL_WORK);
        tagFieldToAsfField.put(FieldKey.PART, AsfFieldKey.PART);
        tagFieldToAsfField.put(FieldKey.PART_NUMBER, AsfFieldKey.PART_NUMBER);
        tagFieldToAsfField.put(FieldKey.PART_TYPE, AsfFieldKey.PART_TYPE);
        tagFieldToAsfField.put(FieldKey.PERFORMER, AsfFieldKey.PERFORMER);
        tagFieldToAsfField.put(FieldKey.PERFORMER_NAME, AsfFieldKey.PERFORMER_NAME);
        tagFieldToAsfField.put(FieldKey.PERFORMER_NAME_SORT, AsfFieldKey.PERFORMER_NAME_SORT);
        tagFieldToAsfField.put(FieldKey.PERIOD, AsfFieldKey.PERIOD);
        tagFieldToAsfField.put(FieldKey.PRODUCER, AsfFieldKey.PRODUCER);
        tagFieldToAsfField.put(FieldKey.QUALITY, AsfFieldKey.QUALITY);
        tagFieldToAsfField.put(FieldKey.RANKING, AsfFieldKey.RANKING);
        tagFieldToAsfField.put(FieldKey.RATING, AsfFieldKey.USER_RATING);
        tagFieldToAsfField.put(FieldKey.RECORD_LABEL, AsfFieldKey.RECORD_LABEL);
        tagFieldToAsfField.put(FieldKey.REMIXER, AsfFieldKey.REMIXER);
        tagFieldToAsfField.put(FieldKey.SCRIPT, AsfFieldKey.SCRIPT);
        tagFieldToAsfField.put(FieldKey.SINGLE_DISC_TRACK_NO, AsfFieldKey.SINGLE_DISC_TRACK_NO);
        tagFieldToAsfField.put(FieldKey.SUBTITLE, AsfFieldKey.SUBTITLE);
        tagFieldToAsfField.put(FieldKey.TAGS, AsfFieldKey.TAGS);
        tagFieldToAsfField.put(FieldKey.TEMPO, AsfFieldKey.TEMPO);
        tagFieldToAsfField.put(FieldKey.TIMBRE, AsfFieldKey.TIMBRE);
        tagFieldToAsfField.put(FieldKey.TITLE, AsfFieldKey.TITLE);
        tagFieldToAsfField.put(FieldKey.TITLE_MOVEMENT, AsfFieldKey.TITLE_MOVEMENT);
        tagFieldToAsfField.put(FieldKey.TITLE_SORT, AsfFieldKey.TITLE_SORT);
        tagFieldToAsfField.put(FieldKey.TONALITY, AsfFieldKey.TONALITY);
        tagFieldToAsfField.put(FieldKey.TRACK, AsfFieldKey.TRACK);
        tagFieldToAsfField.put(FieldKey.TRACK_TOTAL, AsfFieldKey.TRACK_TOTAL);
        tagFieldToAsfField.put(FieldKey.URL_DISCOGS_ARTIST_SITE, AsfFieldKey.URL_DISCOGS_ARTIST_SITE);
        tagFieldToAsfField.put(FieldKey.URL_DISCOGS_RELEASE_SITE, AsfFieldKey.URL_DISCOGS_RELEASE_SITE);
        tagFieldToAsfField.put(FieldKey.URL_LYRICS_SITE, AsfFieldKey.URL_LYRICS_SITE);
        tagFieldToAsfField.put(FieldKey.URL_OFFICIAL_ARTIST_SITE, AsfFieldKey.URL_OFFICIAL_ARTIST_SITE);
        tagFieldToAsfField.put(FieldKey.URL_OFFICIAL_RELEASE_SITE, AsfFieldKey.URL_OFFICIAL_RELEASE_SITE);
        tagFieldToAsfField.put(FieldKey.URL_WIKIPEDIA_ARTIST_SITE, AsfFieldKey.URL_WIKIPEDIA_ARTIST_SITE);
        tagFieldToAsfField.put(FieldKey.URL_WIKIPEDIA_RELEASE_SITE, AsfFieldKey.URL_WIKIPEDIA_RELEASE_SITE);
        tagFieldToAsfField.put(FieldKey.WORK, AsfFieldKey.WORK);
        tagFieldToAsfField.put(FieldKey.WORK_TYPE, AsfFieldKey.WORK_TYPE);
        tagFieldToAsfField.put(FieldKey.YEAR, AsfFieldKey.YEAR);
        COMMON_FIELDS = new HashSet<AsfFieldKey>();
        COMMON_FIELDS.add(AsfFieldKey.ALBUM);
        COMMON_FIELDS.add(AsfFieldKey.AUTHOR);
        COMMON_FIELDS.add(AsfFieldKey.DESCRIPTION);
        COMMON_FIELDS.add(AsfFieldKey.GENRE);
        COMMON_FIELDS.add(AsfFieldKey.TITLE);
        COMMON_FIELDS.add(AsfFieldKey.TRACK);
        COMMON_FIELDS.add(AsfFieldKey.YEAR);
    }

    private static class AsfFieldIterator
    implements Iterator<AsfTagField> {
        private final Iterator<TagField> fieldIterator;

        public AsfFieldIterator(Iterator<TagField> iterator) {
            assert (iterator != null);
            this.fieldIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.fieldIterator.hasNext();
        }

        @Override
        public AsfTagField next() {
            return (AsfTagField)this.fieldIterator.next();
        }

        @Override
        public void remove() {
            this.fieldIterator.remove();
        }
    }
}

