/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac.metadatablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.flac.metadatablock.BlockType;
import org.jaudiotagger.logging.ErrorMessage;

public class MetadataBlockHeader {
    public static final int BLOCK_TYPE_LENGTH = 1;
    public static final int BLOCK_LENGTH = 3;
    public static final int HEADER_LENGTH = 4;
    private long startByte;
    private boolean isLastBlock;
    private int dataLength;
    private byte[] bytes;
    private BlockType blockType;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");

    public static MetadataBlockHeader readHeader(FileChannel fc) throws CannotReadException, IOException {
        ByteBuffer rawdata = ByteBuffer.allocate(4);
        long startByte = fc.position();
        int bytesRead = fc.read(rawdata);
        if (bytesRead < 4) {
            throw new IOException("Unable to read required number of databytes read:" + bytesRead + ":required:" + 4);
        }
        rawdata.rewind();
        return new MetadataBlockHeader(startByte, rawdata);
    }

    public String toString() {
        return String.format("StartByte:%d BlockType:%s DataLength:%d isLastBlock:%s", new Object[]{this.startByte, this.blockType, this.dataLength, this.isLastBlock});
    }

    public MetadataBlockHeader(long startByte, ByteBuffer rawdata) throws CannotReadException {
        this.startByte = startByte;
        this.isLastBlock = (rawdata.get(0) & 0x80) >>> 7 == 1;
        int type = rawdata.get(0) & 0x7F;
        if (type < BlockType.values().length) {
            this.blockType = BlockType.values()[type];
            this.dataLength = (this.u(rawdata.get(1)) << 16) + (this.u(rawdata.get(2)) << 8) + this.u(rawdata.get(3));
            this.bytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                this.bytes[i] = rawdata.get(i);
            }
        } else {
            throw new CannotReadException(ErrorMessage.FLAC_NO_BLOCKTYPE.getMsg(type));
        }
    }

    public MetadataBlockHeader(boolean isLastBlock, BlockType blockType, int dataLength) {
        ByteBuffer rawdata = ByteBuffer.allocate(4);
        this.blockType = blockType;
        this.isLastBlock = isLastBlock;
        this.dataLength = dataLength;
        byte type = isLastBlock ? (byte)(0x80 | blockType.getId()) : (byte)blockType.getId();
        rawdata.put(type);
        rawdata.put((byte)((dataLength & 0xFF0000) >>> 16));
        rawdata.put((byte)((dataLength & 0xFF00) >>> 8));
        rawdata.put((byte)(dataLength & 0xFF));
        this.bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.bytes[i] = rawdata.get(i);
        }
    }

    private int u(int i) {
        return i & 0xFF;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    public boolean isLastBlock() {
        return this.isLastBlock;
    }

    public byte[] getBytesWithoutIsLastBlockFlag() {
        this.bytes[0] = (byte)(this.bytes[0] & 0x7F);
        return this.bytes;
    }

    public byte[] getBytesWithLastBlockFlag() {
        this.bytes[0] = (byte)(this.bytes[0] | 0x80);
        return this.bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

