sub iniRead
 { 
	my $ini = $_[0];
	my $conf;
	open (INI, "$ini") || return $conf;
	while (<INI>) {
		chomp;
		if (/^\s*\[\s*(.+?)\s*\]\s*$/) {
			$section = $1;
		}

		if ( /^\s*([^=]+?)\s*=\s*(.*?)\s*$/ ) {
			$conf->{$section}->{$1} = $2;         
		}
	}
	close (INI);
	return $conf;
}
sub iniWrite
{
	my $ini = $_[0];
	my $conf = $_[1];
	my $contents = '';
	foreach my $section ( sort { (($b eq '_') <=> ($a eq '_')) || ($a cmp $b) } keys %$conf ) {
		my $block = $conf->{$section};
		$contents .= "\n" if length $contents;
		$contents .= "[$section]\n" unless $section eq '_';
		foreach my $property ( sort keys %$block ) {
			$contents .= "$property=$block->{$property}\n";
		}
	}
	open( CONF,"> $ini" ) or print("not open the file");
	print CONF $contents;
	close CONF;
}
sub iniPrint
{
	my $ini = $_[0];
	my $conf = $_[1];
	my $contents = '';
	foreach my $section ( sort { (($b eq '_') <=> ($a eq '_')) || ($a cmp $b) } keys %$conf ) {
		my $block = $conf->{$section};
		$contents .= "\n" if length $contents;
		$contents .= "[$section]\n" unless $section eq '_';
		foreach my $property ( sort keys %$block ) {
			$contents .= "$property=$block->{$property}\n";
		}
	}
	print $contents;
}

$inifile = $ARGV[0];
$conf = iniRead($inifile);

$type = $ARGV[1];
@tm = qw(application/x-tmd application/x-tmv application/x-tmdx application/x-tmvx application/msword application/vnd.ms-word application/x-doc text/rtf application/rtf application/vnd.oasis.opendocument.text application/vnd.oasis.opendocument.text-template application/vnd.stardivision.writer application/vnd.sun.xml.writer application/vnd.sun.xml.writer.template application/vnd.openxmlformats-officedocument.wordprocessingml.document application/vnd.ms-word.document.macroenabled.12 application/vnd.ms-word.document.macroEnabled.12 application/vnd.openxmlformats-officedocument.wordprocessingml.template application/vnd.ms-word.template.macroenabled.12 application/vnd.ms-word.template.macroEnabled.12 application/x-pocket-word application/vnd.wordperfect);
foreach $key(@tm)
{
	$conf->{"Added Associations"}->{"$key"}="$type;".$conf->{"Added Associations"}->{"$key"};
}
$type = $ARGV[2];
@pm = qw(application/x-pmd application/x-pmdx application/x-pmv application/excel application/x-excel application/x-ms-excel application/x-msexcel application/x-sylk application/x-xls application/xls application/vnd.ms-excel application/vnd.stardivision.calc application/vnd.openxmlformats-officedocument.spreadsheetml.sheet application/vnd.openxmlformats-officedocument.spreadsheetml.template application/vnd.ms-excel.sheet.macroenabled.12 application/vnd.ms-excel.sheet.macroEnabled.12 application/vnd.openxmlformats-officedocument.spreadsheetml.template application/vnd.ms-excel.template.macroenabled.12 application/vnd.ms-excel.template.macroEnabled.12 text/csv application/x-dbf application/x-dif application/x-prn application/vnd.stardivision.calc text/spreadsheet application/x-pagemaker);
foreach $key(@pm)
{
	$conf->{"Added Associations"}->{"$key"}="$type;".$conf->{"Added Associations"}->{"$key"};
}
$type = $ARGV[3];
@pr = qw(application/x-prd application/x-prv application/x-prs application/x-prdx application/x-prvx application/x-prsx application/ppt application/mspowerpoint application/vnd.ms-powerpoint application/vnd.openxmlformats-officedocument.presentationml.presentation application/vnd.ms-powerpoint.presentation.macroenabled.12 application/vnd.ms-powerpoint.presentation.macroEnabled.12 application/vnd.openxmlformats-officedocument.presentationml.template application/vnd.ms-powerpoint.template.macroenabled.12 application/vnd.ms-powerpoint.template.macroEnabled.12 application/vnd.ms-powerpoint.slideshow.macroenabled.12 application/vnd.ms-powerpoint.slideshow.macroEnabled.12 application/vnd.openxmlformats-officedocument.presentationml.slideshow);
foreach $key(@pr)
{
	$conf->{"Added Associations"}->{"$key"}="$type;".$conf->{"Added Associations"}->{"$key"};
}
iniPrint($inifile,$conf);
iniWrite($inifile,$conf);

