/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger poolId = new AtomicInteger();
    private final ThreadGroup group;
    private final String namePrefix;
    private final int threadPriority;
    private final boolean daemon;

    public NamedThreadFactory(String poolNamePrefix) {
        this(poolNamePrefix, Thread.currentThread().getThreadGroup(), 10, true);
    }

    public NamedThreadFactory(String poolNamePrefix, boolean isDaemon) {
        this(poolNamePrefix, Thread.currentThread().getThreadGroup(), 10, isDaemon);
    }

    public NamedThreadFactory(String poolNamePrefix, ThreadGroup group) {
        this(poolNamePrefix, group, 10, true);
    }

    public NamedThreadFactory(String poolNamePrefix, ThreadGroup group, boolean isDaemon) {
        this(poolNamePrefix, group, 10, isDaemon);
    }

    public NamedThreadFactory(String poolNamePrefix, int threadPriority) {
        this(poolNamePrefix, threadPriority, true);
    }

    public NamedThreadFactory(String poolNamePrefix, int threadPriority, boolean isDaemon) {
        this(poolNamePrefix, null, threadPriority, isDaemon);
    }

    public NamedThreadFactory(String poolNamePrefix, ThreadGroup group, int threadPriority, boolean isDaemon) {
        this.daemon = isDaemon;
        this.namePrefix = poolNamePrefix;
        this.group = group == null ? Thread.currentThread().getThreadGroup() : group;
        if (threadPriority < 1) {
            throw new IllegalArgumentException(String.format("Thread priority (%s) must be >= %s", threadPriority, 1));
        }
        if (threadPriority > 10) {
            throw new IllegalArgumentException(String.format("Thread priority (%s) must be <= %s", threadPriority, 10));
        }
        this.threadPriority = threadPriority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + '-' + this.poolId.incrementAndGet());
        t.setDaemon(this.daemon);
        if (t.getPriority() != this.threadPriority) {
            t.setPriority(this.threadPriority);
        }
        return t;
    }
}

