/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.OS;
import java.lang.reflect.Method;
import org.slf4j.LoggerFactory;

public class JavaFX {
    public static final boolean isLoaded;
    public static final boolean isGtk3;
    private static final Method dispatchMethod;
    private static final Method isEventThreadMethod;
    private static final Object isEventThreadObject;

    public static void dispatch(Runnable runnable) {
        try {
            dispatchMethod.invoke(null, runnable);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(JavaFX.class).error("Unable to execute JavaFX runLater(). Please create an issue with your OS and Java version so we may further investigate this issue.");
        }
    }

    public static boolean isEventThread() {
        try {
            if (OS.javaVersion <= 7) {
                return (Boolean)isEventThreadMethod.invoke(null, new Object[0]);
            }
            return (Boolean)isEventThreadMethod.invoke(isEventThreadObject, new Object[0]);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(JavaFX.class).error("Unable to check if JavaFX is in the event thread. Please create an issue with your OS and Java version so we may further investigate this issue.");
            return false;
        }
    }

    public static void onShutdown(Runnable runnable) {
        try {
            Class<?> clazz = Class.forName("com.sun.javafx.tk.Toolkit");
            Method method = clazz.getMethod("getToolkit", new Class[0]);
            Object o = method.invoke(null, new Object[0]);
            Method m = o.getClass().getMethod("addShutdownHook", Runnable.class);
            m.invoke(o, runnable);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(JavaFX.class).error("Unable to insert shutdown hook into JavaFX. Please create an issue with your OS and Java version so we may further investigate this issue.");
        }
    }

    static {
        boolean isJavaFxLoaded_ = false;
        boolean isJavaFxGtk3_ = false;
        try {
            Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            m.setAccessible(true);
            ClassLoader cl = JavaFX.class.getClassLoader();
            boolean bl = isJavaFxLoaded_ = null != m.invoke((Object)cl, "com.sun.javafx.tk.Toolkit") || null != m.invoke((Object)cl, "javafx.application.Application");
            if (isJavaFxLoaded_) {
                isJavaFxGtk3_ = OS.javaVersion >= 9 && System.getProperty("jdk.gtk.version", "2").equals("3");
            }
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(JavaFX.class).debug("Error detecting if JavaFX is loaded", e);
        }
        isLoaded = isJavaFxLoaded_;
        isGtk3 = isJavaFxGtk3_;
        Method _isEventThreadMethod = null;
        Method _dispatchMethod = null;
        Object _isEventThreadObject = null;
        if (isJavaFxLoaded_) {
            try {
                Class<?> clazz = Class.forName("javafx.application.Platform");
                _dispatchMethod = clazz.getMethod("runLater", Runnable.class);
                if (OS.javaVersion <= 7) {
                    clazz = Class.forName("javafx.application.Platform");
                    _isEventThreadMethod = clazz.getMethod("isFxApplicationThread", new Class[0]);
                    _isEventThreadObject = null;
                } else {
                    clazz = Class.forName("com.sun.javafx.tk.Toolkit");
                    _isEventThreadMethod = clazz.getMethod("getToolkit", new Class[0]);
                    _isEventThreadObject = _isEventThreadMethod.invoke(null, new Object[0]);
                    _isEventThreadMethod = _isEventThreadObject.getClass().getMethod("isFxUserThread", null);
                }
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(JavaFX.class).error("Cannot initialize JavaFX", e);
            }
        }
        dispatchMethod = _dispatchMethod;
        isEventThreadMethod = _isEventThreadMethod;
        isEventThreadObject = _isEventThreadObject;
    }
}

