/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.executor.ShellExecutor;
import dorkbox.util.OS;
import dorkbox.util.OSUtil;
import dorkbox.util.SwingUtil;
import dorkbox.util.jna.linux.GnomeVFS;
import dorkbox.util.jna.linux.GtkCheck;
import dorkbox.util.jna.linux.GtkEventDispatch;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class Desktop {
    private static final String GVFS = "/usr/bin/gvfs-open";
    private static final boolean GVFS_VALID = new File("/usr/bin/gvfs-open").canExecute();

    public static void open(final File file) throws IOException {
        if (file == null) {
            throw new IOException("File must not be null.");
        }
        if ((OS.isUnix() || OS.isLinux()) && GtkCheck.isGtkLoaded) {
            Desktop.launchNix(file.toString());
        } else if (java.awt.Desktop.isDesktopSupported() && java.awt.Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support browsing for a URL");
        }
    }

    public static void browseURL(String address) throws IOException {
        if (address == null || address.isEmpty()) {
            throw new IOException("Address must not be null or empty.");
        }
        try {
            URI uri = new URI(address);
            Desktop.browseURL(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI " + address);
        }
    }

    public static void browseURL(final URI uri) throws IOException {
        if (uri == null) {
            throw new IOException("URI must not be null.");
        }
        if ((OS.isUnix() || OS.isLinux()) && GtkCheck.isGtkLoaded) {
            Desktop.launchNix(uri.toString());
        } else if (java.awt.Desktop.isDesktopSupported() && java.awt.Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().browse(uri);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support browsing for a URL");
        }
    }

    public static void launchEmail(String address) throws IOException {
        if (address == null || address.isEmpty()) {
            throw new IOException("Address must not be null or empty.");
        }
        try {
            if (!address.startsWith("mailto:")) {
                address = "mailto:" + address;
            }
            URI uri = new URI(address);
            Desktop.launchEmail(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI " + address);
        }
    }

    public static void launchEmail(final URI uri) throws IOException {
        if (uri == null) {
            throw new IOException("URI must not be null.");
        }
        if ((OS.isUnix() || OS.isLinux()) && GtkCheck.isGtkLoaded) {
            Desktop.launchNix(uri.toString());
        } else if (java.awt.Desktop.isDesktopSupported() && java.awt.Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().mail(uri);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support launching an email client");
        }
    }

    public static void browseDirectory(String path) throws IOException {
        if (path == null || path.isEmpty()) {
            throw new IOException("Path must not be null or empty.");
        }
        if (OS.isMacOsX()) {
            File child;
            File directory = new File(path);
            File[] files = directory.listFiles();
            if (files != null && files.length > 0 && !ShellExecutor.run("open", "-R", (child = files[0]).getCanonicalPath())) {
                throw new IOException("Error opening the directory for " + path);
            }
        } else if ((OS.isUnix() || OS.isLinux()) && GtkCheck.isGtkLoaded) {
            if (!path.contains("://")) {
                path = "file://" + path;
            }
            Desktop.launchNix(path);
        } else if (java.awt.Desktop.isDesktopSupported() && java.awt.Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            final String finalPath = path;
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().open(new File(finalPath));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support opening a directory to browse");
        }
    }

    private static void launchNix(final String path) {
        if (GVFS_VALID) {
            ShellExecutor.run(GVFS, path);
        } else if (OSUtil.DesktopEnv.isGnome() && GnomeVFS.isInited) {
            GtkEventDispatch.dispatch(new Runnable(){

                @Override
                public void run() {
                    int errorCode = GnomeVFS.gnome_vfs_url_show_with_env(path, null);
                    if (errorCode != 0) {
                        ShellExecutor.run("xdg-open", path);
                    }
                }
            });
        } else {
            ShellExecutor.run("xdg-open", path);
        }
    }
}

