/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.ui.swing.SwingMenuItem;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.HeavyCheckMark;
import dorkbox.util.FontUtil;
import dorkbox.util.SwingUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

class SwingMenuItemCheckbox
extends SwingMenuItem
implements CheckboxPeer {
    private volatile boolean isChecked = false;
    private static volatile ImageIcon checkedIcon;

    SwingMenuItemCheckbox(SwingMenu parent, Entry entry) {
        super(parent, entry);
        if (checkedIcon == null) {
            try {
                JMenuItem jMenuItem = new JMenuItem();
                if (SystemTray.SWING_UI != null) {
                    jMenuItem.setUI(SystemTray.SWING_UI.getItemUI(jMenuItem, null));
                }
                int size = FontUtil.getFontHeight(jMenuItem.getFont(), "X");
                int menuImageSize = SystemTray.get().getMenuImageSize();
                String checkmarkPath = SystemTray.SWING_UI != null ? SystemTray.SWING_UI.getCheckMarkIcon(jMenuItem.getForeground(), size, menuImageSize) : HeavyCheckMark.get(jMenuItem.getForeground(), size, menuImageSize);
                checkedIcon = new ImageIcon(checkmarkPath);
            }
            catch (Exception e) {
                SystemTray.logger.error("Error creating check-mark image.", e);
            }
        }
    }

    @Override
    public void setEnabled(final Checkbox menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItemCheckbox.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final Checkbox menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItemCheckbox.this._native.setText(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(final Checkbox menuItem) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    menuItem.setChecked(!SwingMenuItemCheckbox.this.isChecked);
                    EventDispatch.runLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                            }
                            catch (Throwable throwable) {
                                SystemTray.logger.error("Error calling menu checkbox entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                            }
                        }
                    });
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(Checkbox menuItem) {
        final int vKey = SwingUtil.getVirtualKey(menuItem.getShortcut());
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItemCheckbox.this._native.setMnemonic(vKey);
            }
        });
    }

    @Override
    public void setChecked(Checkbox menuItem) {
        boolean checked = menuItem.getChecked();
        if (checked != this.isChecked) {
            this.isChecked = checked;
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SwingMenuItemCheckbox.this.isChecked) {
                        SwingMenuItemCheckbox.this._native.setIcon(checkedIcon);
                    } else {
                        SwingMenuItemCheckbox.this._native.setIcon(SwingMenuItem.transparentIcon);
                    }
                }
            });
        }
    }

    @Override
    public void setTooltip(final Checkbox menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItemCheckbox.this._native.setToolTipText(menuItem.getTooltip());
            }
        });
    }
}

