/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.awt;

import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.awt.AwtMenu;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.SwingUtil;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class AwtMenuItem
implements MenuItemPeer {
    private final AwtMenu parent;
    private final java.awt.MenuItem _native = new java.awt.MenuItem();
    private volatile ActionListener callback;

    AwtMenuItem(AwtMenu parent) {
        this.parent = parent;
        parent._native.add(this._native);
    }

    @Override
    public void setImage(MenuItem menuItem) {
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItem.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItem.this._native.setLabel(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventDispatch.runLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                            }
                            catch (Throwable throwable) {
                                SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                            }
                        }
                    });
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        final int vKey = SwingUtil.getVirtualKey(menuItem.getShortcut());
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItem.this._native.setShortcut(new MenuShortcut(vKey));
            }
        });
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
    }

    @Override
    public void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItem.this._native.deleteShortcut();
                AwtMenuItem.this._native.setEnabled(false);
                if (AwtMenuItem.this.callback != null) {
                    AwtMenuItem.this._native.removeActionListener(AwtMenuItem.this.callback);
                    AwtMenuItem.this.callback = null;
                }
                ((AwtMenuItem)AwtMenuItem.this).parent._native.remove(AwtMenuItem.this._native);
                AwtMenuItem.this._native.removeNotify();
            }
        });
    }
}

