/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.gnomeShell;

import dorkbox.executor.ShellAsyncExecutor;
import dorkbox.executor.ShellExecutor;
import dorkbox.systemTray.SystemTray;
import dorkbox.util.IO;
import dorkbox.util.OS;
import dorkbox.util.OSUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtensionSupport {
    public static List<String> getEnabledExtensions() {
        ShellExecutor gsettings = new ShellExecutor();
        gsettings.setExecutable("gsettings");
        gsettings.addArgument("get");
        gsettings.addArgument("org.gnome.shell");
        gsettings.addArgument("enabled-extensions");
        gsettings.start();
        String output = gsettings.getOutput();
        StringBuilder stringBuilder = new StringBuilder(output);
        int extensionIndex = output.indexOf("]");
        if (extensionIndex > 0) {
            stringBuilder.delete(extensionIndex, stringBuilder.length());
        }
        if ((extensionIndex = output.indexOf("[")) >= 0) {
            stringBuilder.delete(0, extensionIndex + 1);
        }
        String installedExtensions = stringBuilder.toString();
        String[] split = installedExtensions.split(", ");
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            int i1 = s.indexOf("'");
            int i2 = s.lastIndexOf("'");
            if (i1 != 0 || i2 != s.length() - 1) continue;
            split[i] = s.substring(1, s.length() - 1);
        }
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(split));
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.trim().isEmpty()) continue;
            iterator.remove();
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installed extensions are: {}", (Object)strings);
        }
        return strings;
    }

    public static void setEnabledExtensions(List<String> extensions) {
        StringBuilder stringBuilder = new StringBuilder("[");
        int extensionsSize = extensions.size();
        int limit = extensionsSize - 1;
        for (int i = 0; i < extensionsSize; ++i) {
            String extension = extensions.get(i);
            if (extension.isEmpty()) continue;
            stringBuilder.append("'").append(extension).append("'");
            if (i >= limit) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Setting installed extensions to: {}", (Object)stringBuilder.toString());
        }
        ShellExecutor setGsettings = new ShellExecutor();
        setGsettings.setExecutable("gsettings");
        setGsettings.addArgument("set");
        setGsettings.addArgument("org.gnome.shell");
        setGsettings.addArgument("enabled-extensions");
        setGsettings.addArgument(stringBuilder.toString());
        setGsettings.start();
    }

    public static void unInstall(String UID, String restartCommand) {
        List<String> enabledExtensions = ExtensionSupport.getEnabledExtensions();
        if (enabledExtensions.contains(UID)) {
            enabledExtensions.remove(UID);
            ExtensionSupport.setEnabledExtensions(enabledExtensions);
            ExtensionSupport.restartShell(restartCommand);
        }
    }

    public static void restartShell(String restartCommand) {
        if (restartCommand == null) {
            return;
        }
        SystemTray.logger.info("Restarting gnome-shell via '{}' so tray notification changes can be applied.", (Object)restartCommand);
        ShellAsyncExecutor.runShell(restartCommand, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readFile(File metaDatafile) {
        StringBuilder builder = new StringBuilder(256);
        BufferedReader bin = null;
        try {
            String line;
            bin = new BufferedReader(new FileReader(metaDatafile));
            while ((line = bin.readLine()) != null) {
                builder.append(line).append("\n");
            }
        }
        catch (Exception e) {
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {
                    SystemTray.logger.error("Error closing: {}", (Object)bin, (Object)e);
                }
            }
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean writeFile(String metadata, File metaDatafile) {
        boolean mkdirs;
        File file = metaDatafile.getParentFile();
        if (!file.isDirectory() && !(mkdirs = file.mkdirs())) {
            String msg = "Unable to create extension location: " + file;
            SystemTray.logger.error(msg);
            return false;
        }
        BufferedWriter outputWriter = null;
        try {
            outputWriter = new BufferedWriter(new FileWriter(metaDatafile, false));
            outputWriter.write(metadata);
            outputWriter.flush();
            outputWriter.close();
        }
        catch (IOException e) {
            SystemTray.logger.error("Error installing extension metadata file", e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (outputWriter != null) {
                try {
                    outputWriter.close();
                }
                catch (IOException e) {
                    SystemTray.logger.error("Error closing: {}", (Object)outputWriter, (Object)e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean installFile(String resourceName, File targetDirectory, String appName) {
        File outputFile = new File(targetDirectory, resourceName);
        try {
            InputStream reader = ExtensionSupport.class.getResourceAsStream(resourceName);
            if (reader == null) {
                SystemTray.logger.error("The {} file resource cannot be found. Something is severely wrong.", (Object)resourceName);
                return false;
            }
            FileWriter fileWriter = new FileWriter(outputFile);
            InputStreamReader inputStreamReader = new InputStreamReader(reader);
            try {
                String line;
                String lineSeparator = OS.LINE_SEPARATOR;
                BufferedReader bin = new BufferedReader(inputStreamReader);
                while ((line = bin.readLine()) != null) {
                    if (line.startsWith("let APP_NAME = \"")) {
                        line = "let APP_NAME = \"" + appName + "\";";
                    }
                    fileWriter.write(line);
                    fileWriter.write(lineSeparator);
                }
            }
            finally {
                IO.closeQuietly(inputStreamReader);
                IO.closeQuietly(fileWriter);
            }
            return true;
        }
        catch (FileNotFoundException e) {
            SystemTray.logger.error("Cannot find gnome-shell extension", e);
        }
        catch (IOException e) {
            SystemTray.logger.error("Unable to get gnome-shell extension", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean installZip(String zipResourceName, File targetDirectory) {
        ZipInputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            ZipEntry entry;
            inputStream = new ZipInputStream(ExtensionSupport.class.getResourceAsStream(zipResourceName));
            while ((entry = inputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                try {
                    boolean mkdirs;
                    if (entry.isDirectory()) continue;
                    File specificOutput = new File(targetDirectory, name);
                    File parentFile = specificOutput.getParentFile();
                    if (!parentFile.exists() && !(mkdirs = parentFile.mkdirs())) {
                        SystemTray.logger.error("Error creating target directory '{}' for Zip support.", (Object)parentFile);
                    }
                    fileOutputStream = new FileOutputStream(specificOutput);
                    IO.copyStream(inputStream, fileOutputStream);
                }
                catch (IOException e) {
                    SystemTray.logger.error("Error extracting zip contents to {}", (Object)targetDirectory);
                }
                finally {
                    if (fileOutputStream == null) continue;
                    IO.closeQuietly(fileOutputStream);
                    fileOutputStream = null;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            SystemTray.logger.error("Cannot find gnome-shell extension", e);
        }
        catch (IOException e) {
            SystemTray.logger.error("Unable to get gnome-shell extension", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    SystemTray.logger.error("Error closing: {}", (Object)inputStream, (Object)e);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    SystemTray.logger.error("Error closing: {}", (Object)fileOutputStream, (Object)e);
                }
            }
        }
        return false;
    }

    protected static String createMetadata(String uid, String appVersion, String appName, String gnomeVersion) {
        return "{\n  \"description\": \"Moves the java SystemTray icon from inside the notification drawer to alongside the clock.\",\n  \"name\": \"Dorkbox SystemTray\",\n  \"app-name-id\": \"" + appName + "\",\n  \"shell-version\": [\n    \"" + gnomeVersion + "\"\n  ],\n  \"url\": \"https://git.dorkbox.com/dorkbox/SystemTray\",\n  \"uuid\": \"" + uid + "\",\n  \"version\": " + appVersion + "\n}\n";
    }

    protected static String getGnomeVersion() {
        int nextIndexOf;
        String gnomeVersion = OSUtil.DesktopEnv.getGnomeVersion();
        if (gnomeVersion == null) {
            return null;
        }
        int indexOf = gnomeVersion.indexOf(46);
        if (indexOf < (nextIndexOf = gnomeVersion.indexOf(46, indexOf + 1))) {
            return gnomeVersion.substring(0, nextIndexOf);
        }
        return gnomeVersion;
    }

    protected static boolean needsUpgrade(String metadata, File metaDatafile) {
        String existingMetadata = ExtensionSupport.readFile(metaDatafile);
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Extension already installed, checking for upgrade");
        }
        if (metadata.equals(existingMetadata)) {
            if (!SystemTray.DEBUG) {
                return false;
            }
            SystemTray.logger.debug("Always upgrading extension in DEBUG mode");
        } else if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Need to upgrade extension");
        }
        return true;
    }
}

