/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.jce.provider;

import java.security.MessageDigest;
import org.gudy.bouncycastle.crypto.Digest;
import org.gudy.bouncycastle.crypto.digests.MD2Digest;
import org.gudy.bouncycastle.crypto.digests.MD4Digest;
import org.gudy.bouncycastle.crypto.digests.MD5Digest;
import org.gudy.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.gudy.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.gudy.bouncycastle.crypto.digests.RIPEMD256Digest;
import org.gudy.bouncycastle.crypto.digests.RIPEMD320Digest;
import org.gudy.bouncycastle.crypto.digests.SHA1Digest;
import org.gudy.bouncycastle.crypto.digests.SHA256Digest;
import org.gudy.bouncycastle.crypto.digests.SHA384Digest;
import org.gudy.bouncycastle.crypto.digests.SHA512Digest;
import org.gudy.bouncycastle.crypto.digests.TigerDigest;

public class JDKMessageDigest
extends MessageDigest {
    Digest digest;

    protected JDKMessageDigest(Digest digest) {
        super(digest.getAlgorithmName());
        this.digest = digest;
    }

    @Override
    public void engineReset() {
        this.digest.reset();
    }

    @Override
    public void engineUpdate(byte input) {
        this.digest.update(input);
    }

    @Override
    public void engineUpdate(byte[] input, int offset, int len) {
        this.digest.update(input, offset, len);
    }

    @Override
    public byte[] engineDigest() {
        byte[] digestBytes = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(digestBytes, 0);
        return digestBytes;
    }

    public static class MD2
    extends JDKMessageDigest
    implements Cloneable {
        public MD2() {
            super(new MD2Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            MD2 d = (MD2)super.clone();
            d.digest = new MD2Digest((MD2Digest)this.digest);
            return d;
        }
    }

    public static class MD4
    extends JDKMessageDigest
    implements Cloneable {
        public MD4() {
            super(new MD4Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            MD4 d = (MD4)super.clone();
            d.digest = new MD4Digest((MD4Digest)this.digest);
            return d;
        }
    }

    public static class MD5
    extends JDKMessageDigest
    implements Cloneable {
        public MD5() {
            super(new MD5Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            MD5 d = (MD5)super.clone();
            d.digest = new MD5Digest((MD5Digest)this.digest);
            return d;
        }
    }

    public static class RIPEMD128
    extends JDKMessageDigest
    implements Cloneable {
        public RIPEMD128() {
            super(new RIPEMD128Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            RIPEMD128 d = (RIPEMD128)super.clone();
            d.digest = new RIPEMD128Digest((RIPEMD128Digest)this.digest);
            return d;
        }
    }

    public static class RIPEMD160
    extends JDKMessageDigest
    implements Cloneable {
        public RIPEMD160() {
            super(new RIPEMD160Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            RIPEMD160 d = (RIPEMD160)super.clone();
            d.digest = new RIPEMD160Digest((RIPEMD160Digest)this.digest);
            return d;
        }
    }

    public static class RIPEMD256
    extends JDKMessageDigest
    implements Cloneable {
        public RIPEMD256() {
            super(new RIPEMD256Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            RIPEMD256 d = (RIPEMD256)super.clone();
            d.digest = new RIPEMD256Digest((RIPEMD256Digest)this.digest);
            return d;
        }
    }

    public static class RIPEMD320
    extends JDKMessageDigest
    implements Cloneable {
        public RIPEMD320() {
            super(new RIPEMD320Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            RIPEMD320 d = (RIPEMD320)super.clone();
            d.digest = new RIPEMD320Digest((RIPEMD320Digest)this.digest);
            return d;
        }
    }

    public static class SHA1
    extends JDKMessageDigest
    implements Cloneable {
        public SHA1() {
            super(new SHA1Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            SHA1 d = (SHA1)super.clone();
            d.digest = new SHA1Digest((SHA1Digest)this.digest);
            return d;
        }
    }

    public static class SHA256
    extends JDKMessageDigest
    implements Cloneable {
        public SHA256() {
            super(new SHA256Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            SHA256 d = (SHA256)super.clone();
            d.digest = new SHA256Digest((SHA256Digest)this.digest);
            return d;
        }
    }

    public static class SHA384
    extends JDKMessageDigest
    implements Cloneable {
        public SHA384() {
            super(new SHA384Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            SHA384 d = (SHA384)super.clone();
            d.digest = new SHA384Digest((SHA384Digest)this.digest);
            return d;
        }
    }

    public static class SHA512
    extends JDKMessageDigest
    implements Cloneable {
        public SHA512() {
            super(new SHA512Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            SHA512 d = (SHA512)super.clone();
            d.digest = new SHA512Digest((SHA512Digest)this.digest);
            return d;
        }
    }

    public static class Tiger
    extends JDKMessageDigest
    implements Cloneable {
        public Tiger() {
            super(new TigerDigest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Tiger d = (Tiger)super.clone();
            d.digest = new TigerDigest((TigerDigest)this.digest);
            return d;
        }
    }
}

