/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1;

import java.io.IOException;
import org.gudy.bouncycastle.asn1.ASN1Object;
import org.gudy.bouncycastle.asn1.ASN1OctetString;
import org.gudy.bouncycastle.asn1.ASN1TaggedObject;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DEROutputStream;
import org.gudy.bouncycastle.asn1.DERString;
import org.gudy.bouncycastle.util.Strings;

public class DERUTF8String
extends ASN1Object
implements DERString {
    String string;

    public static DERUTF8String getInstance(Object obj) {
        if (obj == null || obj instanceof DERUTF8String) {
            return (DERUTF8String)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERUTF8String(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERUTF8String.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERUTF8String.getInstance(obj.getObject());
    }

    DERUTF8String(byte[] string) {
        this.string = Strings.fromUTF8ByteArray(string);
    }

    public DERUTF8String(String string) {
        this.string = string;
    }

    @Override
    public String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String s = (DERUTF8String)o;
        return this.getString().equals(s.getString());
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(12, Strings.toUTF8ByteArray(this.string));
    }
}

