/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.webplugin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.biglybt.core.pairing.PairedService;
import com.biglybt.core.pairing.PairedServiceRequestHandler;
import com.biglybt.core.pairing.PairingConnectionData;
import com.biglybt.core.pairing.PairingManager;
import com.biglybt.core.pairing.PairingManagerFactory;
import com.biglybt.core.pairing.PairingManagerListener;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SHA1Hasher;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginConfig;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.ipfilter.IPRange;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.logging.LoggerChannelListener;
import com.biglybt.pif.tracker.Tracker;
import com.biglybt.pif.tracker.TrackerException;
import com.biglybt.pif.tracker.TrackerTorrent;
import com.biglybt.pif.tracker.web.TrackerAuthenticationAdapter;
import com.biglybt.pif.tracker.web.TrackerWebContext;
import com.biglybt.pif.tracker.web.TrackerWebPageGenerator;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.components.UITextArea;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.HyperlinkParameter;
import com.biglybt.pif.ui.config.InfoParameter;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.LabelParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.config.PasswordParameter;
import com.biglybt.pif.ui.config.StringListParameter;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.plugin.upnp.UPnPMapping;
import com.biglybt.plugin.upnp.UPnPPlugin;
import com.biglybt.util.JSONUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.json.simple.JSONObject;

public class WebPlugin
implements Plugin,
TrackerWebPageGenerator {
    public static final String PR_ENABLE = "Enable";
    public static final String PR_DISABLABLE = "Disablable";
    public static final String PR_PORT = "Port";
    public static final String PR_BIND_IP = "Bind IP";
    public static final String PR_ROOT_RESOURCE = "Root Resource";
    public static final String PR_HOME_PAGE = "Home Page";
    public static final String PR_ROOT_DIR = "Root Dir";
    public static final String PR_ACCESS = "Access";
    public static final String PR_LOG = "DefaultLoggerChannel";
    public static final String PR_CONFIG_MODEL_PARAMS = "DefaultConfigModelParams";
    public static final String PR_CONFIG_MODEL = "DefaultConfigModel";
    public static final String PR_VIEW_MODEL = "DefaultViewModel";
    public static final String PR_HIDE_RESOURCE_CONFIG = "DefaultHideResourceConfig";
    public static final String PR_ENABLE_KEEP_ALIVE = "DefaultEnableKeepAlive";
    public static final String PR_PAIRING_SID = "PairingSID";
    public static final String PR_NON_BLOCKING = "NonBlocking";
    public static final String PR_ENABLE_PAIRING = "EnablePairing";
    public static final String PR_ENABLE_I2P = "EnableI2P";
    public static final String PR_ENABLE_TOR = "EnableTor";
    public static final String PR_ENABLE_UPNP = "EnableUPNP";
    public static final String PROPERTIES_MIGRATED = "Properties Migrated";
    public static final String PAIRING_MIGRATED = "Pairing Migrated";
    public static final String PAIRING_SESSION_KEY = "Pairing Session Key";
    public static final String CONFIG_PASSWORD_ENABLE = "Password Enable";
    public static final boolean CONFIG_PASSWORD_ENABLE_DEFAULT = false;
    public static final String CONFIG_NO_PW_WHITELIST = "Password Disabled Whitelist";
    public static final String CONFIG_NO_PW_WHITELIST_DEFAULT = "localhost, 127.0.0.1, [::1], $";
    public static final String CONFIG_PAIRING_ENABLE = "Pairing Enable";
    public static final boolean CONFIG_PAIRING_ENABLE_DEFAULT = true;
    public static final String CONFIG_PORT_OVERRIDE = "Port Override";
    public static final String CONFIG_PAIRING_AUTO_AUTH = "Pairing Auto Auth";
    public static final boolean CONFIG_PAIRING_AUTO_AUTH_DEFAULT = true;
    public static final String CONFIG_ENABLE = "Enable";
    public boolean CONFIG_ENABLE_DEFAULT = true;
    public static final String CONFIG_USER = "User";
    public static final String CONFIG_USER_DEFAULT = "";
    public static final String CONFIG_PASSWORD = "Password";
    public static final byte[] CONFIG_PASSWORD_DEFAULT = new byte[0];
    public static final String CONFIG_PORT = "Port";
    public int CONFIG_PORT_DEFAULT = 8089;
    public static final String CONFIG_BIND_IP = "Bind IP";
    public String CONFIG_BIND_IP_DEFAULT = "";
    public static final String CONFIG_PROTOCOL = "Protocol";
    public static final String CONFIG_PROTOCOL_DEFAULT = "HTTP";
    public static final String CONFIG_UPNP_ENABLE = "UPnP Enable";
    public boolean CONFIG_UPNP_ENABLE_DEFAULT = true;
    public static final String CONFIG_HOME_PAGE = "Home Page";
    public String CONFIG_HOME_PAGE_DEFAULT = "index.html";
    public static final String CONFIG_ROOT_DIR = "Root Dir";
    public String CONFIG_ROOT_DIR_DEFAULT = "";
    public static final String CONFIG_ROOT_RESOURCE = "Root Resource";
    public String CONFIG_ROOT_RESOURCE_DEFAULT = "";
    public static final String CONFIG_MODE = "Mode";
    public static final String CONFIG_MODE_FULL = "full";
    public static final String CONFIG_MODE_DEFAULT = "full";
    public static final String CONFIG_ACCESS = "Access";
    public String CONFIG_ACCESS_DEFAULT = "all";
    protected static final String NL = "\r\n";
    protected static final String[] welcome_pages = new String[]{"index.html", "index.htm", "index.php", "index.tmpl"};
    protected static File[] welcome_files;
    private static final AsyncDispatcher network_dispatcher;
    protected PluginInterface plugin_interface;
    private LoggerChannel log;
    private PluginConfig plugin_config;
    private BasicPluginViewModel view_model;
    private BasicPluginConfigModel config_model;
    private String p_sid;
    private StringParameter param_home;
    private StringParameter param_rootdir;
    private StringParameter param_rootres;
    private IntParameter param_port;
    private StringListParameter param_protocol;
    private StringParameter param_bind;
    private StringParameter param_access;
    private InfoParameter param_i2p_dest;
    private InfoParameter param_tor_dest;
    private BooleanParameter p_upnp_enable;
    private BooleanParameter pw_enable;
    private StringParameter p_user_name;
    private PasswordParameter p_password;
    private StringParameter p_no_pw_whitelist;
    private BooleanParameter param_auto_auth;
    private IntParameter param_port_or;
    private boolean setting_auto_auth;
    private String pairing_access_code;
    private String pairing_session_code;
    private boolean plugin_enabled;
    private boolean na_intf_listener_added;
    private String home_page;
    private File file_root;
    private String resource_root;
    private String root_dir;
    private boolean ip_range_all = false;
    private List<IPRange> ip_ranges;
    private TrackerWebContext tracker_context;
    private UPnPMapping upnp_mapping;
    private PairingManagerListener pairing_listener;
    private Properties properties;
    private static ThreadLocal<String> tls;
    private static final int LOGOUT_GRACE_MILLIS = 5000;
    private static final String GRACE_PERIOD_MARKER = "<grace_period>";
    private Map<String, Long> logout_timer = new HashMap<String, Long>();
    private boolean unloaded;

    static {
        network_dispatcher = new AsyncDispatcher("webplugin:netdispatch", 5000);
        tls = new ThreadLocal<String>(){

            @Override
            public String initialValue() {
                return null;
            }
        };
    }

    public WebPlugin() {
        this.properties = new Properties();
    }

    public WebPlugin(Properties defaults) {
        this.properties = defaults;
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        HyperlinkParameter pairing_test;
        HyperlinkParameter connection_test;
        BooleanParameter pairing_enable;
        LabelParameter pairing_info;
        BooleanParameter param_enable;
        Boolean disablable;
        Boolean prop_pairing_enable;
        Boolean pr_enable_upnp;
        String pr_access;
        String pr_root_dir;
        String pr_home_page;
        String pr_root_resource;
        String pr_bind_ip;
        Integer pr_port;
        Boolean pr_enable;
        Object o;
        this.plugin_interface = _plugin_interface;
        this.plugin_config = this.plugin_interface.getPluginconfig();
        Properties plugin_properties = this.plugin_interface.getPluginProperties();
        if (plugin_properties != null && (o = plugin_properties.get("plugin." + "Root Dir".replaceAll(" ", "_"))) instanceof String) {
            this.properties.put("Root Dir", o);
        }
        if ((pr_enable = (Boolean)this.properties.get("Enable")) != null) {
            this.CONFIG_ENABLE_DEFAULT = pr_enable;
        }
        if ((pr_port = (Integer)this.properties.get("Port")) != null) {
            this.CONFIG_PORT_DEFAULT = pr_port;
        }
        if ((pr_bind_ip = (String)this.properties.get("Bind IP")) != null) {
            this.CONFIG_BIND_IP_DEFAULT = pr_bind_ip.trim();
        }
        if ((pr_root_resource = (String)this.properties.get("Root Resource")) != null) {
            this.CONFIG_ROOT_RESOURCE_DEFAULT = pr_root_resource;
        }
        if ((pr_home_page = (String)this.properties.get("Home Page")) != null) {
            this.CONFIG_HOME_PAGE_DEFAULT = pr_home_page;
        }
        if ((pr_root_dir = (String)this.properties.get("Root Dir")) != null) {
            this.CONFIG_ROOT_DIR_DEFAULT = pr_root_dir;
        }
        if ((pr_access = (String)this.properties.get("Access")) != null) {
            this.CONFIG_ACCESS_DEFAULT = pr_access;
        }
        if ((pr_enable_upnp = (Boolean)this.properties.get(PR_ENABLE_UPNP)) != null) {
            this.CONFIG_UPNP_ENABLE_DEFAULT = pr_enable_upnp;
        }
        Boolean pr_hide_resource_config = (Boolean)this.properties.get(PR_HIDE_RESOURCE_CONFIG);
        this.log = (LoggerChannel)this.properties.get(PR_LOG);
        if (this.log == null) {
            this.log = this.plugin_interface.getLogger().getChannel("WebPlugin");
        }
        if ((prop_pairing_enable = (Boolean)this.properties.get(PR_ENABLE_PAIRING)) == null || prop_pairing_enable.booleanValue()) {
            this.p_sid = (String)this.properties.get(PR_PAIRING_SID);
        }
        UIManager ui_manager = this.plugin_interface.getUIManager();
        this.view_model = (BasicPluginViewModel)this.properties.get(PR_VIEW_MODEL);
        if (this.view_model == null) {
            this.view_model = ui_manager.createBasicPluginViewModel(this.plugin_interface.getPluginName());
        }
        String plugin_id = this.plugin_interface.getPluginID();
        String sConfigSectionID = "plugins." + plugin_id;
        this.view_model.setConfigSectionID(sConfigSectionID);
        this.view_model.getStatus().setText("Running");
        this.view_model.getActivity().setVisible(false);
        this.view_model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String message) {
                this.log(String.valueOf(message) + "\n");
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                this.log(String.valueOf(str) + "\n");
                this.log(String.valueOf(Debug.getNestedExceptionMessage(error)) + "\n");
            }

            private void log(String str) {
                UITextArea area = WebPlugin.this.view_model.getLogArea();
                if (area != null) {
                    area.appendText(str);
                }
            }
        });
        this.config_model = (BasicPluginConfigModel)this.properties.get(PR_CONFIG_MODEL);
        if (this.config_model == null) {
            String[] cm_params = (String[])this.properties.get(PR_CONFIG_MODEL_PARAMS);
            this.config_model = cm_params == null || cm_params.length == 0 ? ui_manager.createBasicPluginConfigModel("plugins", sConfigSectionID) : (cm_params.length == 1 ? ui_manager.createBasicPluginConfigModel(cm_params[0]) : ui_manager.createBasicPluginConfigModel(cm_params[0], cm_params[1]));
        }
        if ((disablable = (Boolean)this.properties.get(PR_DISABLABLE)) != null && disablable.booleanValue()) {
            param_enable = this.config_model.addBooleanParameter2("Enable", "webui.enable", this.CONFIG_ENABLE_DEFAULT);
            this.plugin_enabled = param_enable.getValue();
        } else {
            param_enable = null;
            this.plugin_enabled = true;
        }
        this.initStage(1);
        this.param_port = this.config_model.addIntParameter2("Port", "webui.port", this.CONFIG_PORT_DEFAULT);
        this.param_port.setGenerateIntermediateEvents(false);
        this.param_bind = this.config_model.addStringParameter2("Bind IP", "webui.bindip", this.CONFIG_BIND_IP_DEFAULT);
        this.param_bind.setGenerateIntermediateEvents(false);
        this.param_protocol = this.config_model.addStringListParameter2(CONFIG_PROTOCOL, "webui.protocol", new String[]{"http", "https"}, CONFIG_PROTOCOL_DEFAULT);
        this.param_protocol.setGenerateIntermediateEvents(false);
        ParameterListener update_server_listener = new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                WebPlugin.this.setupServer();
            }
        };
        this.param_port.addListener(update_server_listener);
        this.param_bind.addListener(update_server_listener);
        this.param_protocol.addListener(update_server_listener);
        this.param_i2p_dest = this.config_model.addInfoParameter2("webui.i2p_dest", CONFIG_USER_DEFAULT);
        this.param_i2p_dest.setVisible(false);
        this.param_tor_dest = this.config_model.addInfoParameter2("webui.tor_dest", CONFIG_USER_DEFAULT);
        this.param_tor_dest.setVisible(false);
        if (param_enable != null) {
            COConfigurationManager.registerExportedParameter(String.valueOf(plugin_id) + ".enable", param_enable.getConfigKeyName());
        }
        COConfigurationManager.registerExportedParameter(String.valueOf(plugin_id) + ".port", this.param_port.getConfigKeyName());
        COConfigurationManager.registerExportedParameter(String.valueOf(plugin_id) + ".protocol", this.param_protocol.getConfigKeyName());
        this.p_upnp_enable = this.config_model.addBooleanParameter2(CONFIG_UPNP_ENABLE, "webui.upnpenable", this.CONFIG_UPNP_ENABLE_DEFAULT);
        this.p_upnp_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                WebPlugin.this.setupUPnP();
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                WebPlugin.this.setupUPnP();
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
        if (this.p_sid != null) {
            final PairingManager pm = PairingManagerFactory.getSingleton();
            pairing_info = this.config_model.addLabelParameter2("webui.pairing.info." + (pm.isEnabled() ? "y" : "n"));
            pairing_enable = this.config_model.addBooleanParameter2(CONFIG_PAIRING_ENABLE, "webui.pairingenable", true);
            if (!this.plugin_config.getPluginBooleanParameter(PAIRING_MIGRATED, false)) {
                boolean has_pw_enabled = this.plugin_config.getPluginBooleanParameter(CONFIG_PASSWORD_ENABLE, false);
                if (has_pw_enabled) {
                    this.plugin_config.setPluginParameter(CONFIG_PAIRING_AUTO_AUTH, false);
                }
                this.plugin_config.setPluginParameter(PAIRING_MIGRATED, true);
            }
            this.param_port_or = this.config_model.addIntParameter2(CONFIG_PORT_OVERRIDE, "webui.port.override", 0);
            this.param_auto_auth = this.config_model.addBooleanParameter2(CONFIG_PAIRING_AUTO_AUTH, "webui.pairing.autoauth", true);
            this.param_auto_auth.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    if (pairing_enable.getValue() && pm.isEnabled()) {
                        WebPlugin.this.setupAutoAuth();
                    } else {
                        WebPlugin.this.setupSessionCode(null);
                    }
                }
            });
            connection_test = this.config_model.addHyperlinkParameter2("webui.connectiontest", this.getConnectionTestURL(this.p_sid));
            URL server_url = PairingManagerFactory.getSingleton().getWebRemoteURL();
            pairing_test = this.config_model.addHyperlinkParameter2("webui.pairingtest", String.valueOf(server_url.toExternalForm()) + "?sid=" + this.p_sid);
            String sid_key = "Plugin." + plugin_id + ".pairing.sid";
            COConfigurationManager.setStringDefault(sid_key, this.p_sid);
            COConfigurationManager.registerExportedParameter(String.valueOf(plugin_id) + ".pairing.sid", sid_key);
            COConfigurationManager.registerExportedParameter(String.valueOf(plugin_id) + ".pairing.enable", pairing_enable.getConfigKeyName());
            COConfigurationManager.registerExportedParameter(String.valueOf(plugin_id) + ".pairing.auto_auth", this.param_auto_auth.getConfigKeyName());
        } else {
            pairing_info = null;
            pairing_enable = null;
            this.param_auto_auth = null;
            this.param_port_or = null;
            pairing_test = null;
            connection_test = null;
        }
        this.config_model.createGroup("ConfigView.section.Pairing", pairing_info, pairing_enable, this.param_port_or, this.param_auto_auth, connection_test, pairing_test);
        this.config_model.createGroup("ConfigView.section.server", this.param_port, this.param_bind, this.param_protocol, this.param_i2p_dest, this.param_tor_dest, this.p_upnp_enable);
        this.param_home = this.config_model.addStringParameter2("Home Page", "webui.homepage", this.CONFIG_HOME_PAGE_DEFAULT);
        this.param_rootdir = this.config_model.addStringParameter2("Root Dir", "webui.rootdir", this.CONFIG_ROOT_DIR_DEFAULT);
        this.param_rootres = this.config_model.addStringParameter2("Root Resource", "webui.rootres", this.CONFIG_ROOT_RESOURCE_DEFAULT);
        if (pr_hide_resource_config != null && pr_hide_resource_config.booleanValue()) {
            this.param_home.setVisible(false);
            this.param_rootdir.setVisible(false);
            this.param_rootres.setVisible(false);
        } else {
            ParameterListener update_resources_listener = new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    WebPlugin.this.setupResources();
                }
            };
            this.param_home.addListener(update_resources_listener);
            this.param_rootdir.addListener(update_resources_listener);
            this.param_rootres.addListener(update_resources_listener);
        }
        LabelParameter a_label1 = this.config_model.addLabelParameter2("webui.mode.info");
        StringListParameter param_mode = this.config_model.addStringListParameter2(CONFIG_MODE, "webui.mode", new String[]{"full", "view"}, "full");
        LabelParameter a_label2 = this.config_model.addLabelParameter2("webui.access.info");
        this.param_access = this.config_model.addStringParameter2("Access", "webui.access", this.CONFIG_ACCESS_DEFAULT);
        this.param_access.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                WebPlugin.this.setupAccess();
            }
        });
        this.pw_enable = this.config_model.addBooleanParameter2(CONFIG_PASSWORD_ENABLE, "webui.passwordenable", false);
        this.p_user_name = this.config_model.addStringParameter2(CONFIG_USER, "webui.user", CONFIG_USER_DEFAULT);
        this.p_password = this.config_model.addPasswordParameter2(CONFIG_PASSWORD, "webui.password", 2, CONFIG_PASSWORD_DEFAULT);
        this.p_no_pw_whitelist = this.config_model.addStringParameter2(CONFIG_NO_PW_WHITELIST, "webui.nopwwhitelist", CONFIG_NO_PW_WHITELIST_DEFAULT);
        this.pw_enable.addEnabledOnSelection((Parameter)this.p_user_name);
        this.pw_enable.addEnabledOnSelection((Parameter)this.p_password);
        this.pw_enable.addDisabledOnSelection((Parameter)this.p_no_pw_whitelist);
        ParameterListener auth_change_listener = new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                if (WebPlugin.this.param_auto_auth != null && !WebPlugin.this.setting_auto_auth) {
                    WebPlugin.this.log("Disabling pairing auto-authentication as overridden by user");
                    WebPlugin.this.param_auto_auth.setValue(false);
                }
                if (param == WebPlugin.this.p_user_name || param == WebPlugin.this.p_password) {
                    WebPlugin.this.setupSessionCode(null);
                }
            }
        };
        this.p_user_name.addListener(auth_change_listener);
        this.p_password.addListener(auth_change_listener);
        this.pw_enable.addListener(auth_change_listener);
        this.config_model.createGroup("webui.group.access", a_label1, param_mode, a_label2, this.param_access, this.pw_enable, this.p_user_name, this.p_password, this.p_no_pw_whitelist);
        if (this.p_sid != null) {
            final PairingManager pm = PairingManagerFactory.getSingleton();
            pairing_enable.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    boolean enabled = pairing_enable.getValue();
                    WebPlugin.this.param_auto_auth.setEnabled(pm.isEnabled() && enabled);
                    WebPlugin.this.param_port_or.setEnabled(pm.isEnabled() && enabled);
                    boolean test_ok = pm.isEnabled() && pairing_enable.getValue() && pm.peekAccessCode() != null && !pm.hasActionOutstanding();
                    pairing_test.setEnabled(test_ok);
                    connection_test.setEnabled(test_ok);
                    WebPlugin.this.setupPairing(WebPlugin.this.p_sid, enabled);
                }
            });
            this.pairing_listener = new PairingManagerListener(){

                @Override
                public void somethingChanged(PairingManager pm) {
                    pairing_info.setLabelKey("webui.pairing.info." + (pm.isEnabled() ? "y" : "n"));
                    if (WebPlugin.this.plugin_enabled) {
                        pairing_enable.setEnabled(pm.isEnabled());
                        WebPlugin.this.param_auto_auth.setEnabled(pm.isEnabled() && pairing_enable.getValue());
                        WebPlugin.this.param_port_or.setEnabled(pm.isEnabled() && pairing_enable.getValue());
                        boolean test_ok = pm.isEnabled() && pairing_enable.getValue() && pm.peekAccessCode() != null && !pm.hasActionOutstanding();
                        pairing_test.setEnabled(test_ok);
                        connection_test.setEnabled(test_ok);
                    }
                    connection_test.setHyperlink(WebPlugin.this.getConnectionTestURL(WebPlugin.this.p_sid));
                    WebPlugin.this.setupPairing(WebPlugin.this.p_sid, pairing_enable.getValue());
                }
            };
            this.pairing_listener.somethingChanged(pm);
            pm.addListener(this.pairing_listener);
            this.setupPairing(this.p_sid, pairing_enable.getValue());
            ParameterListener update_pairing_listener = new ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    WebPlugin.this.updatePairing(WebPlugin.this.p_sid);
                    WebPlugin.this.setupUPnP();
                }
            };
            this.param_port.addListener(update_pairing_listener);
            this.param_port_or.addListener(update_pairing_listener);
            this.param_protocol.addListener(update_pairing_listener);
        }
        if (param_enable != null) {
            final ArrayList<Parameter> changed_params = new ArrayList<Parameter>();
            if (!this.plugin_enabled) {
                Parameter[] params;
                Parameter[] parameterArray = params = this.config_model.getParameters();
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter param = parameterArray[n2];
                    if (param != param_enable && param.isEnabled()) {
                        changed_params.add(param);
                        param.setEnabled(false);
                    }
                    ++n2;
                }
            }
            param_enable.addListener(new ParameterListener(){

                @Override
                public void parameterChanged(Parameter e_p) {
                    WebPlugin.this.plugin_enabled = ((BooleanParameter)e_p).getValue();
                    if (WebPlugin.this.plugin_enabled) {
                        for (Parameter p : changed_params) {
                            p.setEnabled(true);
                        }
                    } else {
                        Parameter[] params;
                        changed_params.clear();
                        Parameter[] parameterArray = params = WebPlugin.this.config_model.getParameters();
                        int n = params.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Parameter param = parameterArray[n2];
                            if (param != e_p && param.isEnabled()) {
                                changed_params.add(param);
                                param.setEnabled(false);
                            }
                            ++n2;
                        }
                    }
                    WebPlugin.this.setupServer();
                    WebPlugin.this.setupUPnP();
                    if (WebPlugin.this.p_sid != null) {
                        WebPlugin.this.setupPairing(WebPlugin.this.p_sid, pairing_enable.getValue());
                    }
                }
            });
        }
        this.setupResources();
        this.setupAccess();
        this.setupServer();
    }

    protected void initStage(int num) {
    }

    private String getConnectionTestURL(String sid) {
        String ac;
        PairingManager pm = PairingManagerFactory.getSingleton();
        URL url = pm.getServiceURL();
        String res = String.valueOf(url.toExternalForm()) + "/web/test?sid=" + sid;
        if (pm.isEnabled() && (ac = pm.peekAccessCode()) != null) {
            res = String.valueOf(res) + "&ac=" + ac;
        }
        return res;
    }

    protected boolean isPluginEnabled() {
        return this.plugin_enabled;
    }

    protected void unloadPlugin() {
        if (this.view_model != null) {
            this.view_model.destroy();
            this.view_model = null;
        }
        if (this.config_model != null) {
            this.config_model.destroy();
            this.config_model = null;
        }
        if (this.tracker_context != null) {
            this.tracker_context.destroy();
            this.tracker_context = null;
        }
        if (this.upnp_mapping != null) {
            this.upnp_mapping.destroy();
            this.upnp_mapping = null;
        }
        if (this.pairing_listener != null) {
            PairingManager pm = PairingManagerFactory.getSingleton();
            pm.removeListener(this.pairing_listener);
            this.pairing_listener = null;
        }
        this.unloaded = true;
    }

    private void setupResources() {
        String error;
        String pluginDirectoryName;
        this.home_page = this.param_home.getValue().trim();
        if (this.home_page.length() == 0) {
            this.home_page = null;
        } else if (!this.home_page.startsWith("/")) {
            this.home_page = "/" + this.home_page;
        }
        this.resource_root = this.param_rootres.getValue().trim();
        if (this.resource_root.length() == 0) {
            this.resource_root = null;
        } else if (this.resource_root.startsWith("/")) {
            this.resource_root = this.resource_root.substring(1);
        }
        this.root_dir = this.param_rootdir.getValue().trim();
        if (this.root_dir.length() == 0) {
            pluginDirectoryName = this.plugin_interface.getPluginDirectoryName();
            this.file_root = pluginDirectoryName == null ? FileUtil.newFile(SystemProperties.getUserPath(), "web") : FileUtil.newFile(pluginDirectoryName, new String[0]);
        } else if (this.root_dir.startsWith(File.separator) || this.root_dir.contains(":")) {
            this.file_root = FileUtil.newFile(this.root_dir, new String[0]);
        } else {
            if (File.separatorChar != '/' && this.root_dir.contains("/")) {
                this.root_dir = this.root_dir.replace('/', File.separatorChar);
            }
            if ((pluginDirectoryName = this.plugin_interface.getPluginDirectoryName()) != null) {
                this.file_root = FileUtil.newFile(pluginDirectoryName, this.root_dir);
                if (!this.file_root.exists()) {
                    try {
                        String pluginClass = this.plugin_interface.getPluginProperties().getProperty("plugin.class");
                        this.file_root = FileUtil.newFile(Class.forName(pluginClass).getProtectionDomain().getCodeSource().getLocation().getPath(), this.root_dir);
                        if (!this.file_root.exists()) {
                            this.file_root = null;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (this.file_root == null) {
                this.file_root = FileUtil.newFile(SystemProperties.getUserPath(), "web", this.root_dir);
            }
        }
        if (!this.file_root.exists()) {
            error = "WebPlugin: root dir '" + this.file_root + "' doesn't exist";
            this.log.log(3, error);
        } else if (!this.file_root.isDirectory()) {
            error = "WebPlugin: root dir '" + this.file_root + "' isn't a directory";
            this.log.log(3, error);
        }
        welcome_files = new File[welcome_pages.length];
        int i = 0;
        while (i < welcome_pages.length) {
            WebPlugin.welcome_files[i] = FileUtil.newFile(this.file_root, welcome_pages[i]);
            ++i;
        }
        this.initStage(2);
    }

    private void setupAccess() {
        String access_str = this.param_access.getValue().trim();
        String ip_ranges_str = CONFIG_USER_DEFAULT;
        this.ip_ranges = null;
        this.ip_range_all = false;
        if (access_str.length() > 7 && Character.isDigit(access_str.charAt(0))) {
            String[] ranges = access_str.replace(';', ',').split(",");
            this.ip_ranges = new ArrayList<IPRange>();
            String[] stringArray = ranges;
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                String range = stringArray[n2];
                if ((range = range.trim()).length() > 7) {
                    IPRange ip_range = this.plugin_interface.getIPFilter().createRange(range.contains(":") ? 2 : 1, true);
                    int sep = range.indexOf("-");
                    if (sep == -1) {
                        ip_range.setStartIP(range);
                        ip_range.setEndIP(range);
                    } else {
                        ip_range.setStartIP(range.substring(0, sep).trim());
                        ip_range.setEndIP(range.substring(sep + 1).trim());
                    }
                    ip_range.checkValid();
                    if (!ip_range.isValid()) {
                        this.log.log(3, "Access parameter '" + range + "' is invalid");
                    } else {
                        this.ip_ranges.add(ip_range);
                        ip_ranges_str = String.valueOf(ip_ranges_str) + (ip_ranges_str.length() == 0 ? CONFIG_USER_DEFAULT : ", ") + ip_range.getStartIP() + " - " + ip_range.getEndIP();
                    }
                }
                ++n2;
            }
            if (this.ip_ranges.size() == 0) {
                this.ip_ranges = null;
            }
        } else if (access_str.equalsIgnoreCase("all") || access_str.length() == 0) {
            this.ip_range_all = true;
        }
        this.log.log(1, "Acceptable IP range = " + (this.ip_ranges == null ? (this.ip_range_all ? "all" : "local") : ip_ranges_str));
    }

    protected boolean verifyReferrer() {
        return true;
    }

    protected void setupServer() {
        try {
            Boolean pr_enable_keep_alive;
            Boolean prop_enable_tor;
            if (!this.plugin_enabled) {
                if (this.tracker_context != null) {
                    this.tracker_context.destroy();
                    this.tracker_context = null;
                }
                return;
            }
            int requested_port = this.param_port.getValue();
            String protocol_str = this.param_protocol.getValue().trim();
            String bind_str = this.param_bind.getValue().trim();
            InetAddress bind_ip = null;
            if (bind_str.length() > 0) {
                NetworkAdmin na;
                InetAddress[] addresses;
                try {
                    bind_ip = InetAddress.getByName(bind_str);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (bind_ip == null && (addresses = (na = NetworkAdmin.getSingleton()).resolveBindAddresses(bind_str)).length > 0) {
                    bind_ip = addresses[0];
                    if (!this.na_intf_listener_added) {
                        this.na_intf_listener_added = true;
                        na.addPropertyChangeListener(new NetworkAdminPropertyChangeListener(){

                            @Override
                            public void propertyChanged(String property) {
                                if (WebPlugin.this.unloaded) {
                                    na.removePropertyChangeListener(this);
                                } else if (property == "Network Interfaces") {
                                    new AEThread2("setupserver"){

                                        @Override
                                        public void run() {
                                            WebPlugin.this.setupServer();
                                        }
                                    }.start();
                                }
                            }
                        });
                    }
                }
                if (bind_ip == null) {
                    this.log.log(3, "Bind IP parameter '" + bind_str + "' is invalid");
                }
            }
            if (this.tracker_context != null) {
                URL url = this.tracker_context.getURLs()[0];
                String existing_protocol = url.getProtocol();
                int existing_port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
                InetAddress existing_bind_ip = this.tracker_context.getBindIP();
                if ((existing_port == requested_port || requested_port == 0) && existing_protocol.equalsIgnoreCase(protocol_str) && this.sameAddress(bind_ip, existing_bind_ip)) {
                    return;
                }
                this.tracker_context.destroy();
                this.tracker_context = null;
            }
            final int protocol = protocol_str.equalsIgnoreCase(CONFIG_PROTOCOL_DEFAULT) ? 1 : 2;
            HashMap<String, Object> tc_properties = new HashMap<String, Object>();
            Boolean prop_non_blocking = (Boolean)this.properties.get(PR_NON_BLOCKING);
            if (prop_non_blocking != null && prop_non_blocking.booleanValue()) {
                tc_properties.put("nonblocking", true);
            }
            this.log.log(1, "Server initialisation: port=" + requested_port + (bind_ip == null ? CONFIG_USER_DEFAULT : ", bind=" + bind_str + "->" + bind_ip + ")") + ", protocol=" + protocol_str + (this.root_dir.length() == 0 ? CONFIG_USER_DEFAULT : ", root=" + this.root_dir) + (this.properties.size() == 0 ? CONFIG_USER_DEFAULT : ", props=" + this.properties));
            this.tracker_context = this.plugin_interface.getTracker().createWebContext(String.valueOf(Constants.APP_NAME) + " - " + this.plugin_interface.getPluginName(), requested_port, protocol, bind_ip, tc_properties);
            final int server_port = this.getServerPort();
            Boolean prop_enable_i2p = (Boolean)this.properties.get(PR_ENABLE_I2P);
            if (prop_enable_i2p == null || prop_enable_i2p.booleanValue()) {
                network_dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        Map<String, Object> reply;
                        HashMap<String, Object> options = new HashMap<String, Object>();
                        options.put("port", server_port);
                        InetAddress bind = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                        if (bind != null && !bind.isAnyLocalAddress()) {
                            options.put("bind", bind.getHostAddress());
                        }
                        if ((reply = AEProxyFactory.getPluginServerProxy(WebPlugin.this.plugin_interface.getPluginName(), "I2P", WebPlugin.this.plugin_interface.getPluginID(), options)) != null) {
                            WebPlugin.this.param_i2p_dest.setVisible(true);
                            String host = (String)reply.get("host");
                            if (!WebPlugin.this.param_i2p_dest.getValue().equals(host)) {
                                WebPlugin.this.param_i2p_dest.setValue(host);
                                if (WebPlugin.this.p_sid != null) {
                                    WebPlugin.this.updatePairing(WebPlugin.this.p_sid);
                                }
                            }
                        }
                    }
                });
            }
            if ((prop_enable_tor = (Boolean)this.properties.get(PR_ENABLE_TOR)) == null || prop_enable_tor.booleanValue()) {
                network_dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        Map<String, Object> reply;
                        HashMap<String, Object> options = new HashMap<String, Object>();
                        options.put("port", server_port);
                        InetAddress bind = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                        if (bind != null && !bind.isAnyLocalAddress()) {
                            options.put("bind", bind.getHostAddress());
                        }
                        if ((reply = AEProxyFactory.getPluginServerProxy(WebPlugin.this.plugin_interface.getPluginName(), "Tor", WebPlugin.this.plugin_interface.getPluginID(), options)) != null) {
                            WebPlugin.this.param_tor_dest.setVisible(true);
                            String host = (String)reply.get("host");
                            if (!WebPlugin.this.param_tor_dest.getValue().equals(host)) {
                                WebPlugin.this.param_tor_dest.setValue(host);
                                if (WebPlugin.this.p_sid != null) {
                                    WebPlugin.this.updatePairing(WebPlugin.this.p_sid);
                                }
                            }
                        }
                    }
                });
            }
            if ((pr_enable_keep_alive = (Boolean)this.properties.get(PR_ENABLE_KEEP_ALIVE)) != null && pr_enable_keep_alive.booleanValue()) {
                this.tracker_context.setEnableKeepAlive(true);
            }
            this.tracker_context.addPageGenerator(this);
            this.tracker_context.addAuthenticationListener(new TrackerAuthenticationAdapter(){
                private String last_pw = "";
                private byte[] last_hash = new byte[0];
                private final int DELAY = 10000;
                private Map<String, Object[]> fail_map = new HashMap<String, Object[]>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public boolean authenticate(String headers, URL resource, String user, String pw) {
                    boolean result;
                    String client_address;
                    block18: {
                        Object waiter;
                        block17: {
                            long now = SystemTime.getMonotonousTime();
                            client_address = this.getHeaderField(headers, "X-Real-IP");
                            if (client_address == null) {
                                client_address = "<unknown>";
                            }
                            Map map = WebPlugin.this.logout_timer;
                            synchronized (map) {
                                Long logout_time = (Long)WebPlugin.this.logout_timer.get(client_address);
                                if (logout_time != null && now - logout_time <= 5000L) {
                                    tls.set(WebPlugin.GRACE_PERIOD_MARKER);
                                    return true;
                                }
                            }
                            result = this.authenticateSupport(client_address, headers, resource, user, pw);
                            if (result) break block17;
                            if (!pw.equals(WebPlugin.CONFIG_USER_DEFAULT)) {
                                waiter = null;
                                Map<String, Object[]> map2 = this.fail_map;
                                synchronized (map2) {
                                    Object[] x = this.fail_map.get(client_address);
                                    if (x == null) {
                                        x = new Object[]{new AESemaphore("af:waiter"), new Long(-1L), new Long(-1L), now};
                                        this.fail_map.put(client_address, x);
                                    } else {
                                        x[1] = x[2];
                                        x[2] = x[3];
                                        x[3] = now;
                                        long t = (Long)x[1];
                                        if (now - t < 10000L) {
                                            WebPlugin.this.log("Too many recent authentication failures from '" + client_address + "' - rate limiting");
                                            x[2] = now + 10000L;
                                            this.last_pw = WebPlugin.CONFIG_USER_DEFAULT;
                                            waiter = (AESemaphore)x[0];
                                        }
                                    }
                                }
                                if (waiter != null) {
                                    ((AESemaphore)waiter).reserve(10000L);
                                }
                            }
                            break block18;
                        }
                        waiter = this.fail_map;
                        synchronized (waiter) {
                            this.fail_map.remove(client_address);
                        }
                        String cookies = this.getHeaderField(headers, "Cookie");
                        if (!(WebPlugin.this.pairing_session_code == null || cookies != null && cookies.contains(WebPlugin.this.pairing_session_code))) {
                            tls.set(WebPlugin.this.pairing_session_code);
                        }
                    }
                    WebPlugin.this.recordAuthRequest(client_address, result);
                    return result;
                }

                private boolean authenticateSupport(String client_address, String headers, URL resource, String user, String pw) {
                    boolean result;
                    boolean auto_auth;
                    block46: {
                        block44: {
                            String[] allowed;
                            String whitelist;
                            block45: {
                                boolean bl = auto_auth = WebPlugin.this.param_auto_auth != null && WebPlugin.this.param_auto_auth.getValue();
                                if (WebPlugin.this.pw_enable.getValue()) break block44;
                                whitelist = WebPlugin.this.p_no_pw_whitelist.getValue().trim();
                                if (!whitelist.equals("*")) break block45;
                                result = true;
                                break block46;
                            }
                            int this_server_port = protocol == 1 ? 80 : 443;
                            String referrer = this.getHeaderField(headers, "referer");
                            String host_maybe_null = this.getHeaderField(headers, "host");
                            if (host_maybe_null != null) {
                                int pos;
                                if (host_maybe_null.startsWith("[")) {
                                    pos = host_maybe_null.lastIndexOf(93);
                                    if (pos != -1) {
                                        String rem = host_maybe_null.substring(pos + 1);
                                        host_maybe_null = host_maybe_null.substring(0, pos + 1);
                                        pos = rem.indexOf(58);
                                        if (pos != -1) {
                                            this_server_port = Integer.parseInt(rem.substring(pos + 1).trim());
                                        }
                                    }
                                } else {
                                    pos = host_maybe_null.indexOf(58);
                                    if (pos != -1) {
                                        this_server_port = Integer.parseInt(host_maybe_null.substring(pos + 1).trim());
                                        host_maybe_null = host_maybe_null.substring(0, pos);
                                    }
                                }
                            }
                            result = false;
                            String msg = WebPlugin.CONFIG_USER_DEFAULT;
                            boolean port_ok = false;
                            String[] stringArray = allowed = whitelist.split(",");
                            int n = allowed.length;
                            int n2 = 0;
                            while (n2 < n) {
                                block48: {
                                    InetAddress bind;
                                    String a;
                                    block49: {
                                        block47: {
                                            int b_pos;
                                            a = stringArray[n2];
                                            a = a.trim();
                                            int explicit_port = -1;
                                            int port_pos = a.lastIndexOf(":");
                                            if (port_pos > 0 && ((b_pos = a.lastIndexOf("]")) == -1 || port_pos > b_pos)) {
                                                try {
                                                    explicit_port = Integer.parseInt(a.substring(port_pos + 1));
                                                    a = a.substring(0, port_pos);
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                            }
                                            port_ok = false;
                                            if (explicit_port <= 0) break block47;
                                            if (this_server_port != explicit_port) break block48;
                                            port_ok = true;
                                            break block49;
                                        }
                                        if (this_server_port != server_port) break block48;
                                    }
                                    if (a.equals("*")) {
                                        result = true;
                                        break;
                                    }
                                    if (a.equals("$") && (bind = WebPlugin.this.getServerBindIP()) != null) {
                                        a = bind instanceof Inet6Address ? "[" + bind.getHostAddress() + "]" : bind.getHostAddress();
                                    }
                                    if (client_address.equals(a.trim())) {
                                        result = true;
                                        break;
                                    }
                                    String aTrimmed = a.trim();
                                    IPRange ip_range = WebPlugin.this.plugin_interface.getIPFilter().createRange(aTrimmed.contains(":") ? 2 : 1, true);
                                    int sep = aTrimmed.indexOf("-");
                                    if (sep == -1) {
                                        ip_range.setStartIP(aTrimmed);
                                        ip_range.setEndIP(aTrimmed);
                                    } else {
                                        ip_range.setStartIP(aTrimmed.substring(0, sep).trim());
                                        ip_range.setEndIP(aTrimmed.substring(sep + 1).trim());
                                    }
                                    ip_range.checkValid();
                                    if (ip_range.isValid() && ip_range.isInRange(client_address)) {
                                        result = true;
                                        break;
                                    }
                                }
                                ++n2;
                            }
                            if (result && !port_ok && this_server_port != server_port) {
                                result = false;
                                msg = "port mismatch: " + server_port + "/" + this_server_port;
                            } else if (!result) {
                                msg = "host '" + client_address + "' not in whitelist";
                            } else if (referrer != null && WebPlugin.this.verifyReferrer() && !port_ok) {
                                result = false;
                                try {
                                    URL url = new URL(referrer);
                                    int ref_port = url.getPort();
                                    if (ref_port == -1) {
                                        ref_port = url.getDefaultPort();
                                    }
                                    if (ref_port == server_port) {
                                        result = true;
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                if (!result) {
                                    msg = "referrer mismatch: " + referrer;
                                }
                            }
                            if (!result) {
                                WebPlugin.this.log.log("Access denied: No password and " + msg + " (" + client_address + ")");
                            }
                            break block46;
                        }
                        if (auto_auth) {
                            user = user.trim().toLowerCase();
                            pw = pw.toUpperCase();
                        }
                        if (!user.equals(WebPlugin.this.p_user_name.getValue())) {
                            WebPlugin.this.log.log("Access denied: Incorrect user name: " + user + " (" + client_address + ")");
                            result = false;
                        } else {
                            byte[] hash = this.last_hash;
                            if (!this.last_pw.equals(pw)) {
                                hash = WebPlugin.this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(auto_auth ? pw.toUpperCase().getBytes() : pw.getBytes());
                                this.last_pw = pw;
                                this.last_hash = hash;
                            }
                            if (!(result = Arrays.equals(hash, WebPlugin.this.p_password.getValue()))) {
                                WebPlugin.this.log.log("Access denied: Incorrect password (" + client_address + ")");
                            }
                        }
                    }
                    if (result) {
                        this.checkCookieSet(headers, resource);
                    } else if (auto_auth) {
                        int x = this.checkCookieSet(headers, resource);
                        if (x == 1) {
                            result = true;
                        } else if (x == 0) {
                            result = WebPlugin.this.hasOurCookie(this.getHeaderField(headers, "Cookie"));
                        }
                    } else {
                        result = WebPlugin.this.hasOurCookie(this.getHeaderField(headers, "Cookie"));
                    }
                    return result;
                }

                private int checkCookieSet(String headers, URL resource) {
                    String[] locations;
                    if (WebPlugin.this.pairing_access_code == null) {
                        return 2;
                    }
                    String[] stringArray = locations = new String[]{resource.getQuery(), this.getHeaderField(headers, "Referer")};
                    int n = locations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String location = stringArray[n2];
                        if (location != null) {
                            boolean skip_fail = false;
                            int param_len = 0;
                            int p1 = location.indexOf("vuze_pairing_ac=");
                            if (p1 == -1) {
                                p1 = location.indexOf("ac=");
                                if (p1 != -1) {
                                    param_len = 3;
                                    skip_fail = true;
                                }
                            } else {
                                param_len = 16;
                            }
                            if (p1 != -1) {
                                int p2 = location.indexOf(38, p1);
                                String ac = location.substring(p1 + param_len, p2 == -1 ? location.length() : p2).trim();
                                p2 = ac.indexOf(35);
                                if (p2 != -1) {
                                    ac = ac.substring(0, p2);
                                }
                                if (ac.equalsIgnoreCase(WebPlugin.this.pairing_access_code)) {
                                    tls.set(WebPlugin.this.pairing_session_code);
                                    return 1;
                                }
                                if (!skip_fail) {
                                    return 2;
                                }
                            }
                        }
                        ++n2;
                    }
                    return 0;
                }

                private String getHeaderField(String headers, String field) {
                    String[] lines;
                    String[] stringArray = lines = headers.split("\n");
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        int pos = line.indexOf(58);
                        if (pos != -1 && line.substring(0, pos).equalsIgnoreCase(field)) {
                            return line.substring(pos + 1).trim();
                        }
                        ++n2;
                    }
                    return null;
                }
            });
        }
        catch (TrackerException e) {
            this.log.log("Server initialisation failed", e);
        }
    }

    private boolean hasOurCookie(String cookies) {
        String[] cookie_list;
        if (cookies == null) {
            return false;
        }
        String[] stringArray = cookie_list = cookies.split(";");
        int n = cookie_list.length;
        int n2 = 0;
        while (n2 < n) {
            String cookie = stringArray[n2];
            String[] bits = cookie.split("=");
            if (bits.length == 2 && bits[0].trim().equals("vuze_pairing_sc") && bits[1].trim().equals(this.pairing_session_code)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean sameAddress(InetAddress a1, InetAddress a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        return a1.equals(a2);
    }

    protected void setupUPnP() {
        if (!this.plugin_enabled || !this.p_upnp_enable.getValue()) {
            if (this.upnp_mapping != null) {
                this.log("Removing UPnP mapping");
                this.upnp_mapping.destroy();
                this.upnp_mapping = null;
            }
            return;
        }
        PluginInterface pi_upnp = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
        if (pi_upnp == null) {
            this.log.log("No UPnP plugin available, not attempting port mapping");
        } else {
            int port = this.param_port.getValue();
            if (this.upnp_mapping != null) {
                if (this.upnp_mapping.getPort() == port) {
                    return;
                }
                this.log("Updating UPnP mapping");
                this.upnp_mapping.destroy();
            } else {
                this.log("Creating UPnP mapping");
            }
            this.upnp_mapping = ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(this.plugin_interface.getPluginName(), true, port, true);
        }
    }

    protected void setupPairing(String sid, boolean pairing_enabled) {
        PairingManager pm = PairingManagerFactory.getSingleton();
        PairedService service = pm.getService(sid);
        if (this.plugin_enabled && pairing_enabled && pm.isEnabled()) {
            this.setupAutoAuth();
            if (service == null) {
                this.log("Adding pairing service");
                service = pm.addService(sid, new PairedServiceRequestHandler(){

                    @Override
                    public byte[] handleRequest(InetAddress originator, String endpoint_url, byte[] request2) throws IOException {
                        return WebPlugin.this.handleTunnelRequest(originator, endpoint_url, request2);
                    }
                });
                PairingConnectionData cd = service.getConnectionData();
                try {
                    this.updatePairing(cd);
                }
                finally {
                    cd.sync();
                }
            }
        } else {
            this.pairing_access_code = null;
            this.setupSessionCode(null);
            if (service != null) {
                this.log("Removing pairing service");
                service.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSessionCode(String key) {
        if (key == null) {
            key = String.valueOf(Base32.encode(this.p_user_name.getValue().getBytes())) + Base32.encode(this.p_password.getValue());
        }
        WebPlugin webPlugin = this;
        synchronized (webPlugin) {
            String existing_key = this.plugin_config.getPluginStringParameter(PAIRING_SESSION_KEY, CONFIG_USER_DEFAULT);
            String[] bits = existing_key.split("=");
            if (bits.length == 2 && bits[0].equals(key)) {
                this.pairing_session_code = bits[1];
            } else {
                this.pairing_session_code = Base32.encode(RandomUtils.nextSecureHash());
                this.plugin_config.setPluginParameter(PAIRING_SESSION_KEY, String.valueOf(key) + "=" + this.pairing_session_code);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupAutoAuth() {
        String ac;
        PairingManager pm = PairingManagerFactory.getSingleton();
        this.pairing_access_code = ac = pm.peekAccessCode();
        if (this.pairing_access_code != null && this.param_auto_auth.getValue()) {
            this.setupSessionCode(ac);
            try {
                this.setting_auto_auth = true;
                if (!this.p_user_name.getValue().equals("vuze")) {
                    this.p_user_name.setValue("vuze");
                }
                SHA1Hasher hasher = new SHA1Hasher();
                byte[] encoded = hasher.calculateHash(this.pairing_access_code.getBytes());
                if (!Arrays.equals(this.p_password.getValue(), encoded)) {
                    this.p_password.setValue(this.pairing_access_code);
                }
                if (this.pw_enable.getValue()) return;
                this.pw_enable.setValue(true);
                return;
            }
            finally {
                this.setting_auto_auth = false;
            }
        } else {
            this.setupSessionCode(null);
        }
    }

    protected void updatePairing(String sid) {
        PairingManager pm = PairingManagerFactory.getSingleton();
        PairedService service = pm.getService(sid);
        if (service != null) {
            PairingConnectionData cd = service.getConnectionData();
            this.log("Updating pairing information");
            try {
                this.updatePairing(cd);
            }
            finally {
                cd.sync();
            }
        }
    }

    protected void updatePairing(PairingConnectionData cd) {
        String host;
        int override;
        cd.setAttribute("port", String.valueOf(this.param_port.getValue()));
        int n = override = this.param_port_or == null ? 0 : this.param_port_or.getValue();
        if (override > 0) {
            cd.setAttribute("port_or", String.valueOf(override));
        } else {
            cd.setAttribute("port_or", null);
        }
        cd.setAttribute("protocol", this.param_protocol.getValue());
        if (this.param_i2p_dest.isVisible() && (host = this.param_i2p_dest.getValue()).length() > 0) {
            cd.setAttribute("I2P", host);
        }
        if (this.param_tor_dest.isVisible() && (host = this.param_tor_dest.getValue()).length() > 0) {
            cd.setAttribute("Tor", host);
        }
    }

    public InetAddress getServerBindIP() {
        if (this.tracker_context == null) {
            return new InetSocketAddress(0).getAddress();
        }
        InetAddress address = this.tracker_context.getBindIP();
        if (address == null) {
            return new InetSocketAddress(0).getAddress();
        }
        return address;
    }

    public int getServerPort() {
        if (this.tracker_context == null) {
            return 0;
        }
        URL url = this.tracker_context.getURLs()[0];
        return url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
    }

    protected String getServerURL() {
        InetAddress bind_ip = this.getServerBindIP();
        InetAddress address = bind_ip.isAnyLocalAddress() ? NetworkAdmin.getSingleton().getLoopbackAddress() : bind_ip;
        return String.valueOf(this.getProtocol().toLowerCase(Locale.US)) + "://" + UrlUtils.getURLForm(address, this.getPort()) + "/";
    }

    public int getPort() {
        return this.param_port.getValue();
    }

    public String getProtocol() {
        return this.param_protocol.getValue();
    }

    public void setUserAndPassword(String user, String password) {
        this.p_user_name.setValue(user);
        this.p_password.setValue(password);
        this.pw_enable.setValue(true);
    }

    public void unsetUserAndPassword() {
        this.pw_enable.setValue(false);
    }

    private void recordAuthRequest(String client_ip, boolean good) {
        PairingManager pm = PairingManagerFactory.getSingleton();
        pm.recordRequest(this.plugin_interface.getPluginName(), client_ip, good);
    }

    private void recordRequest(TrackerWebPageRequest request2, boolean good, boolean is_tunnel) {
        PairingManager pm = PairingManagerFactory.getSingleton();
        String str = request2.getClientAddress();
        if (is_tunnel) {
            str = "Tunnel (" + str + ")";
        }
        pm.recordRequest(this.plugin_interface.getPluginName(), str, good);
    }

    public boolean generateSupport(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        return false;
    }

    private byte[] handleTunnelRequest(final InetAddress originator, String endpoint_url, final byte[] request_bytes) throws IOException {
        int data_start;
        int q_pos = endpoint_url.indexOf(63);
        boolean raw = true;
        if (q_pos != -1) {
            String params = endpoint_url.substring(q_pos + 1);
            String[] args = params.split("&");
            String new_endpoint = endpoint_url.substring(0, q_pos);
            String sep = "?";
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.startsWith("tunnel_format=")) {
                    String temp = arg.substring(14);
                    if (temp.startsWith("h")) {
                        raw = false;
                    }
                } else {
                    new_endpoint = String.valueOf(new_endpoint) + sep + arg;
                    sep = "&";
                }
                ++n2;
            }
            endpoint_url = new_endpoint;
        }
        final String f_endpoint_url = endpoint_url;
        final JSONObject request_headers = new JSONObject();
        if (raw) {
            data_start = 0;
        } else {
            int request_header_len = request_bytes[0] << 8 & 0xFF00 | request_bytes[1] & 0xFF;
            String reply_json_str = new String(request_bytes, 2, request_header_len, "UTF-8");
            request_headers.putAll(JSONUtils.decodeJSON(reply_json_str));
            data_start = request_header_len + 2;
        }
        TrackerWebPageRequest request2 = new TrackerWebPageRequest(){

            @Override
            public Tracker getTracker() {
                return null;
            }

            @Override
            public String getClientAddress() {
                return originator.getHostAddress();
            }

            @Override
            public InetSocketAddress getClientAddress2() {
                return new InetSocketAddress(originator, 0);
            }

            @Override
            public InetSocketAddress getLocalAddress() {
                return new InetSocketAddress("127.0.0.1", 0);
            }

            @Override
            public String getUser() {
                return null;
            }

            @Override
            public String getURL() {
                String url = (String)request_headers.get("HTTP-URL");
                if (url != null) {
                    return url;
                }
                return f_endpoint_url;
            }

            @Override
            public String getHeader() {
                return WebPlugin.CONFIG_USER_DEFAULT;
            }

            @Override
            public Map getHeaders() {
                return request_headers;
            }

            @Override
            public InputStream getInputStream() {
                return new ByteArrayInputStream(request_bytes, data_start, request_bytes.length - data_start);
            }

            @Override
            public URL getAbsoluteURL() {
                try {
                    return new URL("http://127.0.0.1" + this.getURL());
                }
                catch (Throwable e) {
                    return null;
                }
            }

            @Override
            public TrackerWebContext getContext() {
                return null;
            }
        };
        final ByteArrayOutputStream[] baos = new ByteArrayOutputStream[]{new ByteArrayOutputStream()};
        final HashMap<String, String> reply_headers = new HashMap<String, String>();
        TrackerWebPageResponse response = new TrackerWebPageResponse(){

            @Override
            public OutputStream getOutputStream() {
                return baos[0];
            }

            @Override
            public void setOutputStream(ByteArrayOutputStream os) {
                baos[0] = os;
            }

            @Override
            public void setReplyStatus(int status) {
                reply_headers.put("HTTP-Status", String.valueOf(status));
            }

            @Override
            public void setContentType(String type) {
                reply_headers.put("Content-Type", type);
            }

            @Override
            public String getContentType() {
                return (String)reply_headers.get("Content-Type");
            }

            @Override
            public void setLastModified(long time) {
            }

            @Override
            public void setExpires(long time) {
            }

            @Override
            public void setHeader(String name, String value) {
                reply_headers.put(name, value);
            }

            @Override
            public void setGZIP(boolean gzip) {
            }

            @Override
            public boolean useFile(String root_dir, String relative_url) throws IOException {
                Debug.out("Not supported");
                return false;
            }

            @Override
            public void useStream(String file_type, InputStream stream) throws IOException {
                Debug.out("Not supported");
            }

            @Override
            public void writeTorrent(TrackerTorrent torrent) throws IOException {
                Debug.out("Not supported");
            }

            @Override
            public void setAsynchronous(boolean async) throws IOException {
                Debug.out("Not supported");
            }

            @Override
            public boolean getAsynchronous() {
                return false;
            }

            @Override
            public OutputStream getRawOutputStream() throws IOException {
                Debug.out("Not supported");
                throw new IOException("Not supported");
            }

            @Override
            public boolean isActive() {
                return true;
            }
        };
        try {
            byte[] bytes;
            if (this.generate2(request2, response, true)) {
                bytes = baos[0].toByteArray();
            } else {
                Debug.out("Tunnelled request not handled: " + request2.getURL());
                response.setReplyStatus(404);
                bytes = new byte[]{};
            }
            if (raw) {
                return bytes;
            }
            String accept_encoding = (String)request_headers.get("Accept-Encoding");
            if (accept_encoding != null && accept_encoding.contains("gzip")) {
                reply_headers.put("Content-Encoding", "gzip");
                ByteArrayOutputStream temp = new ByteArrayOutputStream(bytes.length + 512);
                GZIPOutputStream gos = new GZIPOutputStream(temp);
                gos.write(bytes);
                gos.close();
                bytes = temp.toByteArray();
            }
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream(bytes.length + 512);
            String header_json = JSONUtils.encodeToJSON(reply_headers);
            byte[] header_bytes = header_json.getBytes("UTF-8");
            int header_len = header_bytes.length;
            byte[] header_len_bytes = new byte[]{(byte)(header_len >> 8), (byte)header_len};
            baos2.write(header_len_bytes);
            baos2.write(header_bytes);
            baos2.write(bytes);
            return baos2.toByteArray();
        }
        catch (Throwable e) {
            Debug.out(e);
            return new byte[0];
        }
    }

    @Override
    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        String url = request2.getURL();
        if (url.startsWith("/pairing/tunnel/")) {
            long error_code = 1L;
            try {
                PairingManager pm = PairingManagerFactory.getSingleton();
                if (pm.isEnabled()) {
                    if (pm.isSRPEnabled()) {
                        return pm.handleLocalTunnel(request2, response);
                    }
                    error_code = 5L;
                    throw new IOException("Secure pairing is not enabled");
                }
                error_code = 5L;
                throw new IOException("Pairing is not enabled");
            }
            catch (Throwable e) {
                JSONObject json = new JSONObject();
                JSONObject error = new JSONObject();
                json.put("error", error);
                error.put("msg", Debug.getNestedExceptionMessage(e));
                error.put("code", (Object)error_code);
                return this.returnJSON(response, JSONUtils.encodeToJSON(json));
            }
        }
        return this.generate2(request2, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generate2(TrackerWebPageRequest request2, TrackerWebPageResponse response, boolean is_tunnel) throws IOException {
        int pos;
        String redirect;
        URL full_url;
        String full_url_path;
        String cookie_to_set;
        String client = request2.getClientAddress();
        if (!this.ip_range_all) {
            try {
                boolean valid_ip = true;
                InetAddress client_ia = InetAddress.getByName(client);
                if (this.ip_ranges == null) {
                    InetAddress bind_ia;
                    if (!(client_ia.isLoopbackAddress() || !(bind_ia = this.getServerBindIP()).isAnyLocalAddress() && bind_ia.equals(client_ia))) {
                        this.log.log(3, "Client '" + client + "' is not local, rejecting");
                        valid_ip = false;
                    }
                } else {
                    boolean ok = false;
                    for (IPRange range : this.ip_ranges) {
                        if (!range.isInRange(client_ia.getHostAddress())) continue;
                        ok = true;
                    }
                    if (!ok) {
                        this.log.log(3, "Client '" + client + "' (" + client_ia.getHostAddress() + ") is not in range, rejecting");
                        valid_ip = false;
                    }
                }
                if (!valid_ip) {
                    response.setReplyStatus(403);
                    this.recordRequest(request2, false, is_tunnel);
                    return this.returnTextPlain(response, "Cannot access resource from this IP address.");
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                this.recordRequest(request2, false, is_tunnel);
                return false;
            }
        }
        this.recordRequest(request2, true, is_tunnel);
        String url = request2.getURL();
        if (url.toString().endsWith(".class")) {
            System.out.println("WebPlugin::generate:" + url);
        }
        if ((cookie_to_set = tls.get()) == GRACE_PERIOD_MARKER) {
            return this.returnTextPlain(response, "Logout in progress, please try again later.");
        }
        if (cookie_to_set != null) {
            response.setHeader("Set-Cookie", "vuze_pairing_sc=" + cookie_to_set + "; path=/; HttpOnly");
            tls.set(null);
        }
        if ((full_url_path = (full_url = request2.getAbsoluteURL()).getPath()).equals("/isPairedServiceAvailable")) {
            redirect = this.getArgumentFromURL(full_url, "redirect_to");
            if (redirect != null) {
                try {
                    URL target = new URL(redirect);
                    String host = target.getHost();
                    if (!Constants.isAppDomain(host) && !InetAddress.getByName(host).isLoopbackAddress()) {
                        this.log("Invalid redirect host: " + host);
                        redirect = null;
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    redirect = null;
                }
            }
            if (redirect != null) {
                response.setReplyStatus(302);
                response.setHeader("Location", redirect);
                return true;
            }
            String callback = this.getArgumentFromURL(full_url, "jsoncallback");
            if (callback != null) {
                return this.returnTextPlain(response, String.valueOf(callback) + "( {'pairedserviceavailable':true} )");
            }
        } else {
            if (full_url_path.equals("/isServicePaired")) {
                boolean paired = cookie_to_set != null || this.hasOurCookie((String)request2.getHeaders().get("cookie"));
                return this.returnTextPlain(response, "{ 'servicepaired': " + (paired ? "true" : "false") + " }");
            }
            if (full_url_path.equals("/pairedServiceLogout")) {
                Map<String, Long> paired = this.logout_timer;
                synchronized (paired) {
                    this.logout_timer.put(client, SystemTime.getMonotonousTime());
                }
                response.setHeader("Set-Cookie", "vuze_pairing_sc=<deleted>, expires=" + TimeFormatter.getCookieDate(0L));
                redirect = this.getArgumentFromURL(full_url, "redirect_to");
                if (redirect != null) {
                    try {
                        URL target = new URL(redirect);
                        String host = target.getHost();
                        if (!Constants.isAppDomain(host) && !InetAddress.getByName(host).isLoopbackAddress()) {
                            this.log("Invalid redirect host: " + host);
                            redirect = null;
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        redirect = null;
                    }
                }
                if (redirect == null) {
                    return this.returnTextPlain(response, CONFIG_USER_DEFAULT);
                }
                response.setReplyStatus(302);
                response.setHeader("Location", redirect);
                return true;
            }
        }
        request2.getHeaders().put("x-vuze-is-tunnel", is_tunnel ? "true" : "false");
        if (this.generateSupport(request2, response)) {
            return true;
        }
        if (is_tunnel) {
            return false;
        }
        if (url.equals("/") || url.startsWith("/?")) {
            url = "/";
            if (this.home_page != null) {
                url = this.home_page;
            } else {
                int i = 0;
                while (i < welcome_files.length) {
                    if (welcome_files[i].exists()) {
                        url = "/" + welcome_pages[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        if (this.useFile(request2, response, this.file_root, UrlUtils.decode(url))) {
            return true;
        }
        String resource_name = url;
        if (resource_name.startsWith("/")) {
            resource_name = resource_name.substring(1);
        }
        if ((pos = resource_name.lastIndexOf(".")) != -1) {
            String type = resource_name.substring(pos + 1);
            ClassLoader cl = this.plugin_interface.getPluginClassLoader();
            InputStream is = cl.getResourceAsStream(resource_name);
            if (is == null && this.resource_root != null) {
                resource_name = String.valueOf(this.resource_root) + "/" + resource_name;
                is = cl.getResourceAsStream(resource_name);
            }
            if (is != null) {
                try {
                    response.useStream(type, is);
                }
                finally {
                    is.close();
                }
                return true;
            }
        }
        return false;
    }

    protected boolean useFile(TrackerWebPageRequest request2, TrackerWebPageResponse response, File root, String relative_url) throws IOException {
        return response.useFile(root.getAbsolutePath(), relative_url);
    }

    private String getArgumentFromURL(URL url, String argument) {
        String query = url.getQuery();
        if (query != null) {
            String[] args;
            String[] stringArray = args = query.split("&");
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                String[] x = arg.split("=");
                if (x.length == 2 && x[0].equals(argument)) {
                    return UrlUtils.decode(x[1]);
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean returnTextPlain(TrackerWebPageResponse response, String str) {
        return this.returnStuff(response, "text/plain", str);
    }

    private boolean returnJSON(TrackerWebPageResponse response, String str) throws IOException {
        response.setContentType("application/json; charset=UTF-8");
        OutputStream os = response.getOutputStream();
        os.write(str.getBytes("UTF-8"));
        return true;
    }

    private boolean returnStuff(TrackerWebPageResponse response, String content_type, String str) {
        response.setContentType(content_type);
        PrintWriter pw = new PrintWriter(response.getOutputStream());
        pw.println(str);
        pw.flush();
        pw.close();
        return true;
    }

    protected BasicPluginConfigModel getConfigModel() {
        return this.config_model;
    }

    protected BasicPluginViewModel getViewModel() {
        return this.view_model;
    }

    protected void log(String str) {
        this.log.log(str);
    }

    protected void log(String str, Throwable e) {
        this.log.log(str, e);
    }
}

