/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.telnet;

import com.biglybt.core.Core;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.torrentdownloader.TorrentDownloaderFactory;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.ui.common.IUserInterface;
import com.biglybt.ui.common.UITemplateHeadless;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.UserProfile;
import com.biglybt.ui.console.multiuser.MultiUserConsoleInput;
import com.biglybt.ui.console.multiuser.UserManager;
import com.biglybt.ui.console.multiuser.commands.UserCommand;
import com.biglybt.ui.telnet.SocketServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class UI
extends UITemplateHeadless
implements IUserInterface {
    private UserManager userManager;

    @Override
    public void buildCommandLine(Options options) {
    }

    @Override
    public String[] processArgs(CommandLine commands, String[] args) {
        int telnetPort = COConfigurationManager.getIntParameter("Telnet_iPort", 57006);
        System.out.println("Telnet port: " + telnetPort);
        return args;
    }

    @Override
    public void coreCreated(Core core) {
        super.coreCreated(core);
        if (core.isStarted()) {
            this.startUI();
            return;
        }
        core.addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public void started(Core core) {
                UI.this.startUI();
            }
        });
    }

    private void startUI() {
        try {
            int telnetPort = COConfigurationManager.getIntParameter("Telnet_iPort", 57006);
            String allowedHostsStr = COConfigurationManager.getStringParameter("Telnet_sAllowedHosts", "127.0.0.1,titan");
            StringTokenizer st = new StringTokenizer(allowedHostsStr, ",");
            HashSet<String> allowedHosts = new HashSet<String>();
            while (st.hasMoreTokens()) {
                allowedHosts.add(st.nextToken().toLowerCase());
            }
            int maxLoginAttempts = COConfigurationManager.getIntParameter("Telnet_iMaxLoginAttempts", 3);
            this.userManager = this.initUserManager();
            Thread thread = new Thread((Runnable)new SocketServer(this, telnetPort, allowedHosts, this.userManager, maxLoginAttempts), "Telnet Socket Server Thread");
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TorrentDownloaderFactory.initManager(this.core.getGlobalManager(), true);
    }

    private UserManager initUserManager() {
        if (System.getProperty(SystemProperties.SYSPROP_CONSOLE_MULTIUSER) != null) {
            return UserManager.getInstance(this.core.getPluginManager().getDefaultPluginInterface());
        }
        return null;
    }

    public void createNewConsoleInput(String consoleName, InputStream inputStream, PrintStream outputStream, UserProfile profile) {
        ConsoleInput console;
        if (this.userManager != null) {
            MultiUserConsoleInput muc = new MultiUserConsoleInput(consoleName, this.core, new InputStreamReader(inputStream), outputStream, Boolean.FALSE, profile);
            muc.registerCommand(new UserCommand(this.userManager));
            console = muc;
        } else {
            console = new ConsoleInput(consoleName, this.core, new InputStreamReader(inputStream), outputStream, Boolean.FALSE, profile);
            System.out.println("TelnetUI: console input instantiated");
        }
        console.printwelcome();
        console.printconsolehelp();
    }
}

