/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.tracker;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.util.Locale;

public class StatusItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private static final String[] js_resource_keys = new String[]{"SpeedView.stats.unknown", "label.disabled", "ManagerItem.stopped", "ManagerItem.queued", "GeneralView.label.updatein.querying", "azbuddy.ui.table.online", "ManagerItem.error", "tps.status.available", "tps.status.unavailable", "ManagerItem.initializing"};
    private static String[] js_resources = new String[js_resource_keys.length];

    public StatusItem(String tableID) {
        super("status", 1, -2, 75, tableID);
        this.setRefreshInterval(-1);
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                int i = 0;
                while (i < js_resources.length) {
                    js_resources[i] = MessageText.getString(js_resource_keys[i]);
                    ++i;
                }
            }
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        String extra;
        TrackerPeerSource ps = (TrackerPeerSource)cell.getDataSource();
        int status = ps == null ? 0 : (ps.isUpdating() ? 4 : ps.getStatus());
        String str = js_resources[status];
        String string = extra = ps == null ? "" : ps.getStatusString();
        if (status == 5) {
            int pos;
            if (extra != null && (pos = extra.indexOf(" (")) != -1) {
                str = String.valueOf(str) + extra.substring(pos);
            }
        } else if ((status == 6 || status == 1 || status == 2 || status == 3) && extra != null) {
            str = String.valueOf(str) + ": " + extra;
        }
        if (!cell.setSortValue((Comparable)((Object)str)) && cell.isValid()) {
            return;
        }
        cell.setText(str);
    }
}

