/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.tracker;

import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class IntervalItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public IntervalItem(String tableID) {
        super("interval", 3, -2, 75, tableID);
        this.setRefreshInterval(-1);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
    }

    @Override
    public void refresh(TableCell cell) {
        TrackerPeerSource ps = (TrackerPeerSource)cell.getDataSource();
        long interval = 0L;
        long min_interval = 0L;
        if (ps != null) {
            interval = ps.getInterval();
            min_interval = ps.getMinInterval();
        }
        long sort = interval << 31;
        if (cell.isSecondarySortEnabled()) {
            sort |= min_interval & 0xFFFFFFFFL;
        }
        if (!cell.setSortValue(sort) && cell.isValid()) {
            return;
        }
        String str = interval <= 0L && min_interval <= 0L ? "" : (interval <= 0L ? "(" + this.format(min_interval) + ")" : (min_interval <= 0L ? this.format(interval) : String.valueOf(this.format(interval)) + " (" + this.format(min_interval) + ")"));
        cell.setText(str);
    }

    private String format(long secs) {
        return TimeFormatter.format2(secs, secs < 300L && secs % 60L != 0L);
    }
}

