/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.pieces;

import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class DownloadNameItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
ObfuscateCellText {
    public static final String COLUMN_ID = "name";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public DownloadNameItem(String table_id) {
        super(COLUMN_ID, 250, table_id);
        this.setPosition(0);
        this.setRefreshInterval(-2);
        this.setType(1);
        this.setMinWidth(100);
        this.setObfuscation(true);
    }

    @Override
    public void refresh(TableCell cell) {
        PEPiece piece = (PEPiece)cell.getDataSource();
        if (piece == null) {
            cell.setText("");
            return;
        }
        PEPeerManager manager = piece.getManager();
        if (manager == null) {
            cell.setText("");
            return;
        }
        cell.setText(manager.getDisplayName());
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        return UIDebugGenerator.obfuscateDownloadName((PEPiece)cell.getDataSource());
    }
}

