/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.pieces;

import com.biglybt.core.diskmanager.cache.CacheFileManagerFactory;
import com.biglybt.core.diskmanager.cache.CacheFileManagerStats;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AERunnable;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.views.PiecesViewBase;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import java.util.Arrays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class BlocksItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellDisposeListener {
    private static final int COLOR_REQUESTED = 0;
    private static final int COLOR_WRITTEN = 1;
    private static final int COLOR_DOWNLOADED = 2;
    private static final int COLOR_INCACHE = 3;
    private static final int COLOR_EGM = 4;
    private static final int COLOR_UPLOADING = 5;
    public static final Color[] colors = new Color[]{Colors.bluesFixed[2], Colors.bluesFixed[9], Colors.red, Colors.grey, Colors.fadedGreen, Colors.yellow};
    private static CacheFileManagerStats cacheStats = null;

    public BlocksItem(String table_id) {
        super("blocks", table_id);
        this.initializeAsGraphic(-2, 200);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
    }

    @Override
    public void cellAdded(TableCell cell) {
        if (cacheStats == null) {
            try {
                cacheStats = CacheFileManagerFactory.getSingleton().getStats();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cell.setFillCell(true);
    }

    @Override
    public void dispose(final TableCell cell) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Image img = ((TableCellSWT)cell).getGraphicSWT();
                if (img != null && !img.isDisposed()) {
                    img.dispose();
                }
            }
        });
    }

    @Override
    public void refresh(final TableCell cell) {
        final PEPiece pePiece = (PEPiece)cell.getDataSource();
        if (pePiece == null) {
            cell.setSortValue(0L);
            this.dispose(cell);
            cell.setGraphic(null);
            return;
        }
        final boolean is_uploading = pePiece instanceof PiecesViewBase.PEPieceUploading;
        cell.setSortValue(pePiece.getNbWritten());
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                long addBlocks;
                Color bg;
                TableRowSWT row;
                PiecePicker picker = pePiece.getPiecePicker();
                long lNumBlocks = pePiece.getNbBlocks();
                int newWidth = cell.getWidth();
                if (newWidth <= 0) {
                    BlocksItem.this.dispose(cell);
                    cell.setGraphic(null);
                    return;
                }
                int newHeight = cell.getHeight();
                int x1 = newWidth - 2;
                int y1 = newHeight - 3;
                if (x1 < 10 || y1 < 3) {
                    BlocksItem.this.dispose(cell);
                    cell.setGraphic(null);
                    return;
                }
                Image image = new Image((Device)Utils.getDisplay(), newWidth, newHeight);
                GC gcImage = new GC((Drawable)image);
                Color bgColor = Colors.white;
                if (Utils.isDarkAppearanceNative() && cell instanceof TableCellSWT && (row = ((TableCellSWT)cell).getTableRowSWT()) != null && (bg = row.getView().getComposite().getBackground()) != null) {
                    bgColor = bg;
                    gcImage.setBackground(bgColor);
                    gcImage.fillRectangle(0, 0, newWidth, newHeight);
                }
                gcImage.setForeground(Utils.isDarkAppearanceNative() ? Colors.dark_grey : Colors.grey);
                gcImage.drawRectangle(0, 0, x1 + 1, y1 + 1);
                int blocksPerPixel = 0;
                int iPixelsPerBlock = 0;
                int pxRes = 0;
                long pxBlockStep = 0L;
                int factor = 4;
                while (iPixelsPerBlock <= 0) {
                    iPixelsPerBlock = (int)((long)(x1 + 1) / (lNumBlocks / (long)(++blocksPerPixel)));
                }
                pxRes = (int)((long)x1 - lNumBlocks / (long)blocksPerPixel * (long)iPixelsPerBlock);
                if (pxRes <= 0) {
                    pxRes = 1;
                }
                if ((addBlocks = lNumBlocks * (long)factor / (pxBlockStep = lNumBlocks * (long)factor / (long)pxRes)) * (long)iPixelsPerBlock > (long)pxRes) {
                    ++pxBlockStep;
                }
                TOTorrent torrent = pePiece.getManager().getDiskManager().getTorrent();
                boolean[] written = pePiece.getDMPiece().getWritten();
                boolean piece_written = pePiece.isWritten();
                int drawnWidth = 0;
                int blockStep = 0;
                int pieceNumber = pePiece.getPieceNumber();
                long[] offsets = new long[(int)lNumBlocks];
                long[] lengths = (long[])offsets.clone();
                Arrays.fill(offsets, (long)pePiece.getManager().getDiskManager().getPieceLength() * (long)pieceNumber);
                int i = 0;
                while ((long)i < lNumBlocks) {
                    lengths[i] = pePiece.getBlockSize(i);
                    int n = i;
                    offsets[n] = offsets[n] + (long)(16384 * i);
                    ++i;
                }
                boolean egm = picker.isInEndGameMode();
                boolean[] isCached = cacheStats == null ? new boolean[(int)lNumBlocks] : cacheStats.getBytesInCache(torrent, offsets, lengths);
                int i2 = 0;
                while ((long)i2 < lNumBlocks) {
                    int nextWidth = iPixelsPerBlock;
                    if ((long)(blockStep += blocksPerPixel * factor) >= pxBlockStep) {
                        nextWidth += (int)((long)blockStep / pxBlockStep);
                        blockStep = (int)((long)blockStep - pxBlockStep);
                    }
                    if ((long)i2 >= lNumBlocks - (long)blocksPerPixel) {
                        nextWidth = x1 - drawnWidth;
                    }
                    Color color = bgColor;
                    int num = -1;
                    if (written == null && piece_written || written != null && written[i2]) {
                        color = colors[1];
                    } else if (pePiece.isDownloaded(i2)) {
                        color = colors[is_uploading ? 5 : 2];
                    } else if (pePiece.isRequested(i2)) {
                        if (egm) {
                            int req_count = picker.getEGMRequestCount(pieceNumber, i2);
                            if (req_count < 2) {
                                color = colors[0];
                            } else {
                                color = colors[4];
                                num = req_count;
                            }
                        } else {
                            color = colors[0];
                        }
                    }
                    gcImage.setBackground(color);
                    gcImage.fillRectangle(drawnWidth + 1, 1, nextWidth, y1);
                    if (isCached[i2]) {
                        gcImage.setBackground(colors[3]);
                        gcImage.fillRectangle(drawnWidth + 1, 1, nextWidth, 3);
                    }
                    if (num >= 0) {
                        gcImage.setForeground(Colors.black);
                        gcImage.drawString(String.valueOf(num), drawnWidth + 1, 0, true);
                    }
                    drawnWidth += nextWidth;
                    i2 += blocksPerPixel;
                }
                gcImage.dispose();
                Image oldImage = null;
                Graphic graphic = cell.getGraphic();
                if (graphic instanceof UISWTGraphic) {
                    oldImage = ((UISWTGraphic)graphic).getImage();
                }
                if (cell instanceof TableCellSWT) {
                    ((TableCellSWT)cell).setGraphic(image);
                } else {
                    cell.setGraphic(new UISWTGraphicImpl(image));
                }
                if (oldImage != null && !oldImage.isDisposed()) {
                    oldImage.dispose();
                }
                gcImage.dispose();
            }
        });
    }
}

