/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import org.eclipse.swt.graphics.Color;

public class SnubbedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private static TableViewSWT.ColorRequester color_requester = () -> 1;

    public SnubbedItem(String table_id) {
        super("S", 3, -1, 20, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"protocol"});
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        boolean bSnubbed = peer == null ? false : peer.isSnubbed();
        if (!cell.setSortValue(bSnubbed ? 1 : 0) && cell.isValid()) {
            return;
        }
        cell.setText(bSnubbed ? "*" : "");
        TableRow row = cell.getTableRow();
        if (row instanceof TableRowSWT) {
            ((TableRowSWT)row).requestForegroundColor(color_requester, (Color)(bSnubbed ? Colors.grey : null));
        }
    }
}

