/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class PercentHaveWeNeedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public PercentHaveWeNeedItem(String table_id) {
        super("haveweneed", 2, -1, 55, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeerManager pm;
        PEPeer peer = (PEPeer)cell.getDataSource();
        int value = -1;
        if (peer != null && !peer.isMyPeer() && (pm = peer.getManager()) != null && !pm.isSeeding()) {
            if (peer.isSeed()) {
                value = 1000 - pm.getDiskManager().getPercentDoneExcludingDND();
            } else {
                boolean[] peer_has;
                BitFlags bf = peer.getAvailable();
                if (bf != null && (peer_has = bf.flags) != null) {
                    int we_have = 0;
                    int we_need = 0;
                    int they_have_we_need = 0;
                    DiskManagerPiece[] dm_pieces = pm.getDiskManager().getPieces();
                    int i = 0;
                    while (i < dm_pieces.length) {
                        DiskManagerPiece piece = dm_pieces[i];
                        if (piece.isNeeded()) {
                            if (piece.isDone()) {
                                ++we_have;
                            } else {
                                ++we_need;
                                if (peer_has[i]) {
                                    ++they_have_we_need;
                                }
                            }
                        }
                        ++i;
                    }
                    if (we_need > 0) {
                        value = 1000 * they_have_we_need / (we_have + we_need);
                    }
                }
            }
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(value < 0 ? "" : DisplayFormatters.formatPercentFromThousands(value));
    }
}

