/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class LatencyItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "latency";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time"});
    }

    public LatencyItem(String table_id) {
        super(COLUMN_ID, 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        Object ds = cell.getDataSource();
        if (ds instanceof PEPeerTransport) {
            PEPeerTransport peer = (PEPeerTransport)ds;
            value = peer.getLatency();
        } else {
            value = 0L;
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(value == 0L ? "" : TimeFormatter.format100ths(value));
    }
}

