/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.net.InetAddress;

public class IpItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
ObfuscateCellText,
TableCellToolTipListener {
    public static final String COLUMN_ID = "ip";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"identification", "connection"});
    }

    public IpItem(String table_id) {
        super(COLUMN_ID, -2, 100, table_id);
        this.setRefreshInterval(-2);
        this.setObfuscation(true);
    }

    @Override
    public void refresh(TableCell cell) {
        String[] sBlocks;
        String sText;
        PEPeer peer = (PEPeer)cell.getDataSource();
        String string = sText = peer == null ? "" : peer.getIp();
        if (!(!cell.setText(sText) && cell.isValid() || sText.contains(";") || (sBlocks = sText.split("\\.")).length != 4)) {
            try {
                long l = (Long.parseLong(sBlocks[0]) << 24) + (Long.parseLong(sBlocks[1]) << 16) + (Long.parseLong(sBlocks[2]) << 8) + Long.parseLong(sBlocks[3]);
                cell.setSortValue(l);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void cellHover(TableCell cell) {
        String str;
        PEPeer peer = (PEPeer)cell.getDataSource();
        if (peer == null) {
            str = "";
        } else {
            String alt;
            String ip = peer.getIp();
            InetAddress ia = peer.getAlternativeIPv6();
            str = ia != null ? (ip.equals(alt = ia.getHostAddress()) ? ip : String.valueOf(ip) + " (" + alt + ")") : ip;
        }
        cell.setToolTip(str);
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        String text = cell.getText();
        return text.length() > 3 ? text.substring(0, 3) : text;
    }
}

