/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class DownSpeedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "downloadspeed";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
    }

    public DownSpeedItem(String table_id) {
        super(COLUMN_ID, 2, -2, 65, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        long sort_value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long data_value = 0L;
        long prot_value = 0L;
        if (peer != null) {
            data_value = peer.getStats().getDataReceiveRate();
            prot_value = peer.getStats().getProtocolReceiveRate();
        }
        if (!cell.setSortValue(sort_value = (data_value << 32) + prot_value) && cell.isValid()) {
            return;
        }
        cell.setNumeric(data_value);
        cell.setText(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(data_value, prot_value));
    }
}

