/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class DownItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "download";
    protected boolean separate_prot_data_stats;
    protected boolean data_stats_only;
    private final ParameterListener parameterListener;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
    }

    public DownItem(String table_id) {
        super(COLUMN_ID, 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
        this.parameterListener = new ParameterListener(){

            @Override
            public void parameterChanged(String x) {
                DownItem.this.separate_prot_data_stats = COConfigurationManager.getBooleanParameter("config.style.separateProtDataStats");
                DownItem.this.data_stats_only = COConfigurationManager.getBooleanParameter("config.style.dataStatsOnly");
            }
        };
        COConfigurationManager.addWeakParameterListener(this.parameterListener, true, "config.style.dataStatsOnly", "config.style.separateProtDataStats");
    }

    @Override
    public void remove() {
        COConfigurationManager.removeWeakParameterListener(this.parameterListener, "config.style.dataStatsOnly", "config.style.separateProtDataStats");
        super.remove();
    }

    @Override
    public void refresh(TableCell cell) {
        long sort_value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long data_value = 0L;
        long prot_value = 0L;
        if (peer != null) {
            data_value = peer.getStats().getTotalDataBytesReceived();
            prot_value = peer.getStats().getTotalProtocolBytesReceived();
        }
        if (!cell.setSortValue(sort_value = this.separate_prot_data_stats ? (data_value << 24) + prot_value : (this.data_stats_only ? data_value : data_value + prot_value)) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatDataProtByteCountToKiBEtc(data_value, prot_value));
    }

    @Override
    public void cellHover(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds instanceof PEPeer) {
            PEPeer peer = (PEPeer)ds;
            long data_value = peer.getStats().getTotalDataBytesReceived();
            long prot_value = peer.getStats().getTotalProtocolBytesReceived();
            StringBuilder sb = new StringBuilder();
            sb.append(DisplayFormatters.formatByteCountToKiBEtc(data_value));
            sb.append(' ');
            sb.append(MessageText.getString("label.transfered.data"));
            sb.append('\n');
            sb.append(DisplayFormatters.formatByteCountToKiBEtc(prot_value));
            sb.append(' ');
            sb.append(MessageText.getString("label.transfered.protocol"));
            sb.append('\n');
            sb.append(DisplayFormatters.formatByteCountToKiBEtc(prot_value + data_value));
            sb.append(' ');
            sb.append(MessageText.getString("label.transfered.total"));
            sb.append('\n');
            cell.setToolTip(sb.toString());
        }
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

