/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class TimeSinceUploadItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
ParameterListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "timesinceupload";
    private static final String CFG_SESSION_ONLY = "ui.timesinceupload.session.only";
    private boolean session;

    public TimeSinceUploadItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
        COConfigurationManager.addWeakParameterListener(this, true, CFG_SESSION_ONLY);
        TableContextMenuItem menuSessionOnly = this.addContextMenuItem("menu.session.only", 1);
        menuSessionOnly.setStyle(2);
        menuSessionOnly.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(TimeSinceUploadItem.this.session);
            }
        });
        menuSessionOnly.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(TimeSinceUploadItem.CFG_SESSION_ONLY, (Boolean)menu.getData());
            }
        });
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.session = COConfigurationManager.getBooleanParameter(CFG_SESSION_ONLY);
    }

    @Override
    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter(CFG_SESSION_ONLY);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int value = dm == null ? -2 : dm.getStats().getTimeSinceLastDataSentInSeconds(this.session);
        if (!cell.setSortValue(value == -1 ? Integer.MAX_VALUE : value) && cell.isValid()) {
            return;
        }
        cell.setText(value == -2 ? "" : (value == -1 ? "\u221e" : TimeFormatter.format(value)));
    }
}

