/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;
import java.text.DecimalFormat;
import org.eclipse.swt.widgets.MessageBox;

public class ShareRatioProgressItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "sr_prog";
    private int existing_sr;
    private ParameterListener paramSRProgressIntervalListener;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "sharing", "swarm"});
        info.setProficiency((byte)1);
    }

    public ShareRatioProgressItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setRefreshInterval(-2);
        this.setMultiline(false);
        this.paramSRProgressIntervalListener = new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                ShareRatioProgressItem.this.existing_sr = COConfigurationManager.getIntParameter(name);
            }
        };
        COConfigurationManager.addWeakParameterListener(this.paramSRProgressIntervalListener, true, "Share Ratio Progress Interval");
        TableContextMenuItem menuSetInterval = this.addContextMenuItem("TableColumn.menu.sr_prog.interval", 1);
        menuSetInterval.setStyle(1);
        menuSetInterval.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("sr_prog.window.title", "sr_prog.window.message");
                final DecimalFormat df = new DecimalFormat("0.000");
                df.setGroupingUsed(false);
                df.setMaximumFractionDigits(3);
                entryWindow.setPreenteredText(df.format((float)ShareRatioProgressItem.this.existing_sr / 1000.0f), false);
                entryWindow.selectPreenteredText(true);
                entryWindow.setWidthHint(400);
                entryWindow.prompt(new UIInputReceiverListener(){

                    @Override
                    public void UIInputReceiverClosed(UIInputReceiver receiver) {
                        if (!receiver.hasSubmittedInput()) {
                            return;
                        }
                        try {
                            String text = receiver.getSubmittedInput().trim();
                            if (text.length() > 0) {
                                float f = DisplayFormatters.parseFloat(df, text);
                                int sr = (int)(f * 1000.0f);
                                COConfigurationManager.setParameter("Share Ratio Progress Interval", sr);
                            }
                        }
                        catch (Throwable e) {
                            MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
                            mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                            mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                            mb.open();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.paramSRProgressIntervalListener, "Share Ratio Progress Interval");
    }

    @Override
    public void refresh(TableCell cell, long _timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null || this.existing_sr <= 0) {
            super.refresh(cell, 0L);
            return;
        }
        long[] info = DisplayFormatters.getShareRatioProgressInfo(dm);
        long sr = info[0];
        long timestamp = info[1];
        long next_eta = info[2];
        String sr_str = DisplayFormatters.formatDecimal((double)sr / 1000.0, 3);
        long sort_order = timestamp;
        if (cell.isSecondarySortEnabled()) {
            sort_order += (sr & 0xFFL) << 8;
            sort_order += next_eta & 0xFFL;
        }
        String next_eta_str = next_eta == -1L ? "" : (next_eta == -2L ? "\u221e: " : String.valueOf(DisplayFormatters.formatETA(next_eta)) + ": ");
        String prefix = String.valueOf(next_eta_str) + sr_str + (timestamp > 0L ? ": " : "");
        super.refresh(cell, timestamp, sort_order, prefix);
    }
}

