/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class PiecesItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellDisposeListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    private static final int INDEX_COLOR_NONEAVAIL = 10;
    private static final int borderHorizontalSize = 1;
    private static final int borderVerticalSize = 1;
    private static final int borderSplit = 1;
    private static final int completionHeight = 2;
    public static final String COLUMN_ID = "pieces";
    private int marginHeight = -1;

    public PiecesItem(String sTableID) {
        this(sTableID, -1);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "progress"});
        info.setProficiency((byte)1);
    }

    public PiecesItem(String sTableID, int marginHeight) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 100, sTableID);
        this.marginHeight = marginHeight;
        this.initializeAsGraphic(-1, 100);
        this.setMinWidth(100);
    }

    @Override
    public void cellAdded(TableCell cell) {
        if (this.marginHeight != -1) {
            cell.setMarginHeight(this.marginHeight);
        }
    }

    @Override
    public void dispose(TableCell cell) {
        DownloadManager infoObj = (DownloadManager)cell.getDataSource();
        if (infoObj == null) {
            return;
        }
        Image img = (Image)infoObj.getUserData("PiecesImage");
        if (img != null && !img.isDisposed()) {
            Utils.execSWTThread(() -> Utils.disposeSWTObjects(img));
        }
        infoObj.setUserData("PiecesImageBuffer", null);
        infoObj.setUserData("PiecesImage", null);
    }

    @Override
    public void refresh(TableCell cell) {
        GC gcImage;
        boolean bForce;
        Rectangle imageBounds;
        boolean bImageChanged;
        DownloadManager infoObj = (DownloadManager)cell.getDataSource();
        long lCompleted = infoObj == null ? 0 : infoObj.getStats().getCompleted();
        Image image = (Image)infoObj.getUserData("PiecesImage");
        int newWidth = cell.getWidth();
        if (newWidth <= 0) {
            return;
        }
        int newHeight = Math.min(cell.getHeight(), 32);
        if (image == null || image.isDisposed()) {
            bImageChanged = true;
        } else {
            imageBounds = image.getBounds();
            bImageChanged = imageBounds.width != newWidth || imageBounds.height != newHeight;
        }
        boolean bl = bForce = infoObj != null || bImageChanged;
        if (!cell.setSortValue(lCompleted) && cell.isValid() && !bForce) {
            return;
        }
        if (infoObj == null) {
            return;
        }
        int x0 = 1;
        int x1 = newWidth - 1 - 1;
        int y0 = 4;
        int y1 = newHeight - 1 - 1;
        int drawWidth = x1 - x0 + 1;
        if (drawWidth < 10 || y1 < 3) {
            return;
        }
        boolean bImageBufferValid = true;
        int[] imageBuffer = (int[])infoObj.getUserData("PiecesImageBuffer");
        if (imageBuffer == null || imageBuffer.length != drawWidth) {
            imageBuffer = new int[drawWidth];
            bImageBufferValid = false;
        }
        if (bImageChanged) {
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            image = new Image((Device)Utils.getDisplay(), newWidth, newHeight);
            imageBounds = image.getBounds();
            bImageBufferValid = false;
            gcImage = new GC((Drawable)image);
            gcImage.setForeground(Colors.grey);
            gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
            gcImage.setForeground(Colors.white);
            gcImage.drawLine(x0, 3, x1, 3);
        } else {
            gcImage = new GC((Drawable)image);
        }
        DiskManager disk_manager = infoObj.getDiskManager();
        DiskManagerPiece[] pieces = disk_manager == null ? infoObj.getDiskManagerPiecesSnapshot() : disk_manager.getPieces();
        int nbPieces = infoObj.getNbPieces();
        try {
            if (nbPieces > 0) {
                int limit;
                int nbComplete = 0;
                int a1 = 0;
                int i = 0;
                while (i < drawWidth) {
                    int index;
                    int a0;
                    if (i == 0) {
                        a0 = 0;
                        a1 = nbPieces / drawWidth;
                        if (a1 == 0) {
                            a1 = 1;
                        }
                    } else {
                        a0 = a1;
                        a1 = (i + 1) * nbPieces / drawWidth;
                    }
                    if (a1 <= a0) {
                        index = imageBuffer[i - 1];
                    } else {
                        int nbAvailable = 0;
                        if (pieces != null) {
                            int j = a0;
                            while (j < a1) {
                                if (pieces[j].isDone()) {
                                    ++nbAvailable;
                                }
                                ++j;
                            }
                        }
                        nbComplete += nbAvailable;
                        index = nbAvailable * 9 / (a1 - a0);
                    }
                    if (!bImageBufferValid || imageBuffer[i] != index) {
                        imageBuffer[i] = index;
                        bImageChanged = true;
                        gcImage.setForeground(index == 10 ? Colors.red : Colors.blues[index]);
                        gcImage.drawLine(i + x0, y0, i + x0, y1);
                    }
                    ++i;
                }
                int n = limit = nbPieces == 0 ? 0 : drawWidth * nbComplete / nbPieces;
                if (limit < drawWidth) {
                    gcImage.setBackground(Colors.blues[0]);
                    gcImage.fillRectangle(limit + x0, 1, x1 - limit, 2);
                }
                gcImage.setBackground(Colors.colorProgressBar);
                gcImage.fillRectangle(x0, 1, limit, 2);
            }
        }
        catch (Exception e) {
            System.out.println("Error Drawing PiecesItem");
            Debug.printStackTrace(e);
        }
        gcImage.dispose();
        Image oldImage = null;
        Graphic graphic = cell.getGraphic();
        if (graphic instanceof UISWTGraphic) {
            oldImage = ((UISWTGraphic)graphic).getImage();
        }
        if (bImageChanged || image != oldImage || !cell.isValid()) {
            if (cell instanceof TableCellSWT) {
                ((TableCellSWT)cell).setGraphic(image);
            } else {
                cell.setGraphic(new UISWTGraphicImpl(image));
            }
            if (bImageChanged) {
                cell.invalidate();
            }
            infoObj.setUserData("PiecesImage", image);
            infoObj.setUserData("PiecesImageBuffer", imageBuffer);
        }
    }
}

