/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.plugin.tracker.dht.DHTTrackerPlugin;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;
import java.util.Locale;
import org.eclipse.swt.graphics.Image;

public class PeersItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
ParameterListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "peers";
    private static final String CFG_SHOW_ICON = "PeersColumn.showNetworkIcon";
    private final MessageText.MessageTextListener messageTextListener;
    private String textStarted;
    private String textStartedOver;
    private String textNotStarted;
    private String textStartedNoScrape;
    private String textNotStartedNoScrape;
    private Image i2p_img;
    private Image none_img;
    private boolean showIcon;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
    }

    public PeersItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 60, sTableID);
        this.setRefreshInterval(-2);
        this.showIcon = COConfigurationManager.getBooleanParameter(CFG_SHOW_ICON);
        COConfigurationManager.addWeakParameterListener(this, false, CFG_SHOW_ICON);
        this.messageTextListener = new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                PeersItem.this.textStarted = MessageText.getString("Column.seedspeers.started");
                PeersItem.this.textStartedOver = MessageText.getString("Column.seedspeers.started.over");
                PeersItem.this.textNotStarted = MessageText.getString("Column.seedspeers.notstarted");
                PeersItem.this.textStartedNoScrape = MessageText.getString("Column.seedspeers.started.noscrape");
                PeersItem.this.textNotStartedNoScrape = MessageText.getString("Column.seedspeers.notstarted.noscrape");
            }
        };
        MessageText.addAndFireListener(this.messageTextListener);
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.i2p_img = imageLoader.getImage("net_I2P_x");
        this.none_img = imageLoader.getImage("net_None_x");
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("ConfigView.section.style.showNetworksIcon", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(PeersItem.this.showIcon);
            }
        });
        menuShowIcon.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(PeersItem.CFG_SHOW_ICON, (Boolean)menu.getData());
            }
        });
    }

    @Override
    public void remove() {
        MessageText.removeListener(this.messageTextListener);
        super.remove();
    }

    @Override
    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter(CFG_SHOW_ICON);
    }

    @Override
    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.setShowIcon(COConfigurationManager.getBooleanParameter(CFG_SHOW_ICON));
    }

    public void setShowIcon(boolean b) {
        this.showIcon = b;
        this.invalidateCells();
    }

    private class Cell
    extends AbstractTrackerCell
    implements TableCellMouseListener {
        long lTotalPeers;

        public Cell(TableCell cell) {
            super(cell);
            this.lTotalPeers = -1L;
        }

        @Override
        protected void updateSeedsPeers(Download download, boolean use_cache) {
            DownloadScrapeResult result;
            if (download != null && (result = download.getAggregatedScrapeResult(use_cache)).getResponseType() == 1) {
                this.lTotalPeers = result.getNonSeedCount();
            }
        }

        @Override
        public void refresh(TableCell cell) {
            String text;
            super.refresh(cell);
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            long lConnectedPeers = 0L;
            if (dm != null) {
                lConnectedPeers = dm.getNbPeers();
                if (this.lTotalPeers == -1L) {
                    this.updateSeedsPeers(this.getDownload(), true);
                }
                if (cell instanceof TableCellSWT) {
                    int totalI2PLeechers;
                    Image icon;
                    int[] i2p_info = (int[])dm.getUserData(DHTTrackerPlugin.DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY);
                    Image image = icon = PeersItem.this.showIcon ? PeersItem.this.none_img : null;
                    if (PeersItem.this.showIcon && i2p_info != null && (totalI2PLeechers = i2p_info[1]) > 0) {
                        icon = PeersItem.this.i2p_img;
                    }
                    ((TableCellSWT)cell).setIcon(icon);
                }
            }
            long totalPeers = this.lTotalPeers;
            long value = lConnectedPeers * 10000000L;
            if (totalPeers > 0L) {
                value += totalPeers;
            }
            if (dm != null) {
                boolean hasScrape;
                int state = dm.getState();
                boolean started = state == 60 || state == 50;
                boolean bl = hasScrape = this.lTotalPeers >= 0L;
                if (started) {
                    text = hasScrape ? (lConnectedPeers > this.lTotalPeers ? PeersItem.this.textStartedOver : PeersItem.this.textStarted) : PeersItem.this.textStartedNoScrape;
                } else {
                    String string = text = hasScrape ? PeersItem.this.textNotStarted : PeersItem.this.textNotStartedNoScrape;
                }
                if (text.length() == 0 && text.length() == 0) {
                    value = Integer.MIN_VALUE;
                    long cache = dm.getDownloadState().getLongAttribute("scrapecache");
                    if (cache != -1L) {
                        int leechers = (int)(cache & 0xFFFFFFL);
                        value += (long)(leechers + 1);
                    }
                }
                if (!cell.setSortValue(value) && cell.isValid()) {
                    return;
                }
                text = text.replaceAll("%1", String.valueOf(lConnectedPeers));
                text = text.replaceAll("%2", String.valueOf(totalPeers));
            } else {
                text = "";
                value = Integer.MIN_VALUE;
                if (!cell.setSortValue(value) && cell.isValid()) {
                    return;
                }
            }
            cell.setText(text);
        }

        @Override
        public void cellHover(TableCell cell) {
            super.cellHover(cell);
            long lConnectedPeers = 0L;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm != null) {
                int totalI2PPeers;
                int[] i2p_info;
                int leechers;
                long cache;
                lConnectedPeers = dm.getNbPeers();
                String sToolTip = String.valueOf(lConnectedPeers) + " " + MessageText.getString("GeneralView.label.connected") + "\n";
                if (this.lTotalPeers != -1L) {
                    sToolTip = String.valueOf(sToolTip) + this.lTotalPeers + " " + MessageText.getString("GeneralView.label.in_swarm");
                } else {
                    Download d = this.getDownload();
                    if (d != null) {
                        DownloadScrapeResult response = d.getAggregatedScrapeResult(true);
                        sToolTip = String.valueOf(sToolTip) + "?? " + MessageText.getString("GeneralView.label.in_swarm");
                        if (response != null) {
                            sToolTip = String.valueOf(sToolTip) + "(" + response.getStatus() + ")";
                        }
                    }
                }
                int activationCount = dm.getActivationCount();
                if (activationCount > 0) {
                    sToolTip = String.valueOf(sToolTip) + "\n" + MessageText.getString("PeerColumn.activationCount", new String[]{"" + activationCount});
                }
                if ((cache = dm.getDownloadState().getLongAttribute("scrapecache")) != -1L && (long)(leechers = (int)(cache & 0xFFFFFFL)) != this.lTotalPeers) {
                    sToolTip = String.valueOf(sToolTip) + "\n" + leechers + " " + MessageText.getString("Scrape.status.cached").toLowerCase(Locale.US);
                }
                if ((i2p_info = (int[])dm.getUserData(DHTTrackerPlugin.DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY)) != null && (totalI2PPeers = i2p_info[1]) > 0) {
                    sToolTip = String.valueOf(sToolTip) + "\n" + MessageText.getString("TableColumn.header.peers.i2p", new String[]{String.valueOf(totalI2PPeers)});
                }
                cell.setToolTip(sToolTip);
            } else {
                cell.setToolTip("");
            }
        }

        @Override
        public void cellMouseTrigger(TableCellMouseEvent event2) {
            DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
            if (dm == null) {
                return;
            }
            if (event2.eventType != 2) {
                return;
            }
            event2.skipCoreFunctionality = true;
            int[] i2p_info = (int[])dm.getUserData(DHTTrackerPlugin.DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY);
            if (i2p_info != null && i2p_info[1] > 0) {
                Utils.launch("https://wiki.biglybt.com/w/Privacy_View");
            }
        }
    }
}

