/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class MergedDataItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellToolTipListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "mergeddata";

    public MergedDataItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
        TableContextMenuItem menuView = this.addContextMenuItem("menu.view.swarm.merge.info");
        menuView.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                if (target instanceof TableRowCore[]) {
                    TableRowCore[] rows;
                    TableRowCore[] tableRowCoreArray = rows = (TableRowCore[])target;
                    int n = rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DownloadManager dm;
                        String info;
                        TableRowCore row = tableRowCoreArray[n2];
                        Object dataSource = row.getDataSource(true);
                        if (dataSource instanceof DownloadManager && (info = (dm = (DownloadManager)dataSource).getSwarmMergingInfo()) != null && !info.isEmpty()) {
                            TextViewerWindow viewer = new TextViewerWindow(Utils.findAnyShell(), "menu.view.swarm.merge.info", dm.getDisplayName(), info, false, false);
                            viewer.setNonProportionalFont();
                        }
                        ++n2;
                    }
                }
            }
        });
        menuView.addFillListener((menu, target) -> {
            boolean enable = false;
            if (target instanceof TableRowCore[]) {
                TableRowCore[] rows;
                TableRowCore[] tableRowCoreArray = rows = (TableRowCore[])target;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    String info;
                    TableRowCore row = tableRowCoreArray[n2];
                    Object dataSource = row.getDataSource(true);
                    if (dataSource instanceof DownloadManager && (info = ((DownloadManager)dataSource).getSwarmMergingInfo()) != null && !info.isEmpty()) {
                        enable = true;
                        break;
                    }
                    ++n2;
                }
            }
            menuView.setEnabled(enable);
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = value = dm == null ? 0L : dm.getDownloadState().getLongAttribute("mergedata");
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(value == 0L ? "" : DisplayFormatters.formatByteCountToKiBEtc(value));
    }

    @Override
    public void cellHover(TableCell cell) {
        String info;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            info = "";
        } else {
            info = dm.getSwarmMergingInfo();
            if (info == null) {
                info = "";
            } else {
                int max_lines;
                String[] lines = info.split("\n");
                if (lines.length > (max_lines = 40)) {
                    info = "";
                    int i = 0;
                    while (i < max_lines) {
                        info = String.valueOf(info) + lines[i] + "\n";
                        ++i;
                    }
                    info = String.valueOf(info) + "...";
                }
            }
        }
        cell.setToolTip(info);
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
    }
}

