/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.text.DecimalFormat;
import org.eclipse.swt.widgets.MessageBox;

public class MaxSRItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "max_sr";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing"});
        info.setProficiency((byte)1);
    }

    public MaxSRItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
        TableContextMenuItem menuItem = this.addContextMenuItem("menu.max.share.ratio2");
        menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                if (target == null) {
                    return;
                }
                final Object[] o = (Object[])target;
                int existing = -1;
                Object[] objectArray = o;
                int n = o.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof TableRowCore) {
                        TableRowCore rowCore = (TableRowCore)object;
                        object = rowCore.getDataSource(true);
                    }
                    if (object instanceof DownloadManager) {
                        int x = ((DownloadManager)object).getDownloadState().getIntParameter("sr.max");
                        if (existing == -1) {
                            existing = x;
                        } else if (existing != x) {
                            existing = -1;
                            break;
                        }
                    }
                    ++n2;
                }
                final DecimalFormat df = new DecimalFormat("0.000");
                df.setGroupingUsed(false);
                df.setMaximumFractionDigits(3);
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("max.sr.window.title", "max.sr.window.message");
                entryWindow.setPreenteredText(existing == -1 ? "" : df.format((float)existing / 1000.0f), false);
                entryWindow.selectPreenteredText(true);
                entryWindow.prompt(new UIInputReceiverListener(){

                    @Override
                    public void UIInputReceiverClosed(UIInputReceiver receiver) {
                        block11: {
                            if (!receiver.hasSubmittedInput()) {
                                return;
                            }
                            try {
                                String text = receiver.getSubmittedInput().trim();
                                int sr = 0;
                                if (text.length() <= 0) break block11;
                                try {
                                    float f = DisplayFormatters.parseFloat(df, text);
                                    sr = (int)(f * 1000.0f);
                                    if (sr < 0) {
                                        sr = 0;
                                    } else if (sr == 0 && f > 0.0f) {
                                        sr = 1;
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                Object[] objectArray = o;
                                int n = o.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object object = objectArray[n2];
                                    if (object instanceof TableRowCore) {
                                        TableRowCore rowCore = (TableRowCore)object;
                                        object = rowCore.getDataSource(true);
                                    }
                                    if (object instanceof DownloadManager) {
                                        ((DownloadManager)object).getDownloadState().setIntParameter("sr.max", sr);
                                    }
                                    ++n2;
                                }
                            }
                            catch (Throwable e) {
                                MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
                                mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                                mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                                mb.open();
                                Debug.out(e);
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int value = 0;
        if (dm != null) {
            value = dm.getDownloadState().getIntParameter("sr.max");
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(value == 0 ? "" : DisplayFormatters.formatDecimal((double)value / 1000.0, 3));
    }
}

