/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.StringInterner;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class FilesDoneItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "filesdone";

    public FilesDoneItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 50, sTableID);
        this.setRefreshInterval(5);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "progress"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String text = "";
        if (dm != null) {
            int complete = 0;
            int skipped = 0;
            int skipped_complete = 0;
            DiskManagerFileInfo[] files = dm.getDiskManagerFileInfo();
            int total = files.length;
            int i = 0;
            while (i < files.length) {
                DiskManagerFileInfo file = files[i];
                if (file.getLength() == file.getDownloaded()) {
                    ++complete;
                    if (file.isSkipped()) {
                        ++skipped;
                        ++skipped_complete;
                    }
                } else if (file.isSkipped()) {
                    ++skipped;
                }
                ++i;
            }
            text = skipped == 0 ? StringInterner.intern(String.valueOf(complete) + "/" + total) : String.valueOf(complete - skipped_complete) + "(" + complete + ")/" + (total - skipped) + "(" + total + ")";
        }
        cell.setText(text);
    }
}

