/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class FileExtensionItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "fileext";

    public FileExtensionItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 50, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        int pos;
        String incomp_suffix;
        DownloadManager dm;
        Object ds = cell.getDataSource();
        String text = "";
        if (ds instanceof DownloadManager) {
            dm = (DownloadManager)ds;
            DiskManagerFileInfo prim = dm.getDownloadState().getPrimaryFile();
            text = prim == null ? "" : prim.getFile(true).getName();
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            dm = fileInfo2.getDownloadManager();
            text = fileInfo2.getFile(true).getName();
        } else {
            return;
        }
        String string = incomp_suffix = dm == null ? null : dm.getDownloadState().getAttribute("incompfilesuffix");
        if (incomp_suffix != null && text.endsWith(incomp_suffix)) {
            text = text.substring(0, text.length() - incomp_suffix.length());
        }
        text = (pos = text.lastIndexOf(".")) >= 0 ? text.substring(pos + 1) : "";
        cell.setText(text);
    }
}

