/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class DownloadHealthItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "download.health";

    public DownloadHealthItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
    }

    @Override
    public void refresh(TableCell cell) {
        String str;
        long sort_val;
        DiskManager disk_manager;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        PEPeerManager pm = dm == null ? null : dm.getPeerManager();
        DiskManager diskManager = disk_manager = pm == null ? null : pm.getDiskManager();
        if (pm == null || disk_manager == null) {
            sort_val = -1L;
            str = "";
        } else {
            long queued_bytes = disk_manager.getWriteStats()[3];
            int unchoking = pm.getNbPeersUnchoking();
            int requests = pm.getMyPeer().getOutgoingRequestCount();
            sort_val = queued_bytes << 32 | (long)(unchoking << 16) | (long)requests;
            str = String.valueOf(DisplayFormatters.formatByteCountToKiBEtc(queued_bytes)) + "/" + unchoking + "/" + requests;
        }
        if (!cell.setSortValue(sort_val) && cell.isValid()) {
            return;
        }
        cell.setText(str);
    }
}

