/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;

public class DescriptionItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener,
TableCellAddedListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "description";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public DescriptionItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 150, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void cellAdded(TableCell cell) {
        if (cell instanceof TableCellSWT) {
            ((TableCellSWT)cell).setCursorID(21);
        }
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        if (event2.eventType != 1) {
            return;
        }
        if (event2.button != 1) {
            return;
        }
        event2.skipCoreFunctionality = true;
        TorrentUtil.promptUserForDescription(new DownloadManager[]{dm});
        this.refresh(event2.cell);
    }

    @Override
    public void refresh(TableCell cell) {
        if (cell.isDisposed()) {
            return;
        }
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String desc = "";
        if (dm != null) {
            try {
                desc = PlatformTorrentUtils.getContentDescription(dm.getTorrent());
                if (desc == null) {
                    desc = "";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        cell.setText(desc);
    }
}

