/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class CommentItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener,
ObfuscateCellText {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "comment";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public CommentItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 300, sTableID);
        this.setRefreshInterval(-2);
        this.setType(1);
        this.setObfuscation(true);
        this.setMinWidth(50);
    }

    @Override
    public void refresh(TableCell cell) {
        String comment = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        comment = dm.getDownloadState().getUserComment();
        if (comment != null) {
            comment = comment.replace('\r', ' ').replace('\n', ' ');
        }
        cell.setText(comment == null ? "" : comment);
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        event2.skipCoreFunctionality = true;
        if (event2.eventType != 2) {
            return;
        }
        TorrentUtil.promptUserForComment(new DownloadManager[]{dm});
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        return Integer.toHexString(dm.hashCode());
    }
}

