/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import org.eclipse.swt.graphics.Image;

public class ColumnTorrentSpeed
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "torrentspeed";
    private Image imgUp;
    private Image imgDown;

    public ColumnTorrentSpeed(String tableID) {
        super(COLUMN_ID, 80, tableID);
        this.setAlignment(2);
        this.setType(1);
        this.setRefreshInterval(-2);
        this.setUseCoreDataSource(false);
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgUp = imageLoader.getImage("image.torrentspeed.up");
        this.imgDown = imageLoader.getImage("image.torrentspeed.down");
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "bytes"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        Object ds = cell.getDataSource();
        if (!(ds instanceof Download)) {
            return;
        }
        Download dm = (Download)ds;
        String prefix = "";
        int iState = dm.getState();
        if (iState == 4) {
            value = dm.getStats().getDownloadAverage();
            ((TableCellSWT)cell).setIcon(this.imgDown);
        } else if (iState == 5) {
            value = dm.getStats().getUploadAverage();
            ((TableCellSWT)cell).setIcon(this.imgUp);
        } else {
            ((TableCellSWT)cell).setIcon(null);
            value = 0L;
        }
        long sortValue = cell.isSecondarySortEnabled() ? value << 4 | (long)iState : value;
        if (cell.setSortValue(sortValue) || !cell.isValid()) {
            cell.setText(value > 0L ? String.valueOf(prefix) + DisplayFormatters.formatByteCountToKiBEtcPerSec(value) : "");
        }
    }
}

