/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnDoneWithDND
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "donewithdnd";

    public ColumnDoneWithDND(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 55, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setRefreshInterval(-2);
        this.setPosition(-1);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)2);
    }

    @Override
    public void refresh(TableCell cell) {
        int value;
        Object ds = cell.getDataSource();
        if (ds instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)ds;
            DownloadManagerStats stats2 = dm.getStats();
            value = stats2.getDownloadCompleted(true);
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            long length = fileInfo2.getLength();
            value = length == 0L ? 1000 : (int)(fileInfo2.getDownloaded() * 1000L / length);
        } else {
            return;
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatPercentFromThousands(value));
    }
}

