/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.util.Map;

public class AlertsItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    private static UISWTGraphic black_tick_icon;
    private static UISWTGraphic gray_tick_icon;
    public static final String COLUMN_ID = "alerts";

    public AlertsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 60, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setRefreshInterval(-2);
        this.initializeAsGraphic(-1, 60);
        this.setMinWidth(20);
        if (black_tick_icon == null || black_tick_icon.getImage() == null) {
            black_tick_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("blacktick"));
        }
        if (gray_tick_icon == null || gray_tick_icon.getImage() == null) {
            gray_tick_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("graytick"));
        }
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        Map map;
        DiskManagerFileInfo fi;
        DownloadManager dm;
        UISWTGraphic icon = null;
        int sort = 0;
        Object ds = cell.getDataSource();
        if (ds instanceof DownloadManager) {
            DownloadManager dm2 = (DownloadManager)ds;
            Map map2 = dm2.getDownloadState().getMapAttribute("df_alerts");
            if (map2 != null && map2.size() > 0) {
                for (String k : map2.keySet()) {
                    if (k.length() <= 0) continue;
                    if (Character.isDigit(k.charAt(0))) {
                        icon = gray_tick_icon;
                        sort = 1;
                        continue;
                    }
                    icon = black_tick_icon;
                    sort = 2;
                    break;
                }
            }
        } else if (ds instanceof DiskManagerFileInfo && (dm = (fi = (DiskManagerFileInfo)ds).getDownloadManager()) != null && (map = dm.getDownloadState().getMapAttribute("df_alerts")) != null && map.size() > 0) {
            String prefix = String.valueOf(fi.getIndex()) + ".";
            for (String k : map.keySet()) {
                if (!k.startsWith(prefix)) continue;
                icon = black_tick_icon;
                sort = 2;
                break;
            }
        }
        cell.setSortValue(sort);
        if (cell.getGraphic() != icon) {
            cell.setGraphic(icon);
        }
    }
}

