/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;
import java.text.NumberFormat;

public class SizeBytesItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public SizeBytesItem() {
        super("sizebytes", 2, -1, 70, "Files");
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        String text;
        long value;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        boolean internal = fileInfo2 instanceof FilesView.FilesViewTreeNode && !((FilesView.FilesViewTreeNode)((Object)fileInfo2)).isLeaf();
        long l = value = fileInfo2 == null ? 0L : fileInfo2.getLength();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value < 0L) {
            text = "";
            cell.setNumeric(Double.NaN);
        } else {
            text = NumberFormat.getNumberInstance().format(value);
            cell.setNumeric(value);
        }
        cell.setText(text);
        TableColumnSWTUtils.setSizeAlpha(cell, value);
    }
}

