/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellLightRefreshListener;
import com.biglybt.pif.ui.tables.TableCellVisibilityListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ProgressGraphItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellDisposeListener,
TableCellVisibilityListener {
    private static final int borderWidth = 1;
    private static Color badAvailColor;

    static {
        COConfigurationManager.addAndFireParameterListener("generalview.avail.bad.colour", n -> {
            badAvailColor = Utils.getConfigColor(n, Colors.maroon);
        });
    }

    public ProgressGraphItem() {
        super("pieces", "Files");
        this.initializeAsGraphic(-2, 200);
        this.setMinWidth(100);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)0);
    }

    @Override
    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    @Override
    public void cellVisibilityChanged(TableCell cell, int visibility) {
        if (visibility == 1) {
            this.dispose(cell);
        }
    }

    @Override
    public void dispose(TableCell cell) {
        Image img;
        Graphic graphic = cell.getGraphic();
        if (graphic instanceof UISWTGraphic && (img = ((UISWTGraphic)graphic).getImage()) != null && !img.isDisposed()) {
            Utils.execSWTThread(() -> Utils.disposeSWTObjects(img));
            ((UISWTGraphic)graphic).setImage(null);
        }
    }

    private class Cell
    implements TableCellLightRefreshListener {
        int lastPercentDone = 0;
        private long last_draw_time = SystemTime.getCurrentTime();
        private boolean bNoRed = false;
        private boolean was_running = false;
        private long lastUnavailabilityIndicator = 0L;

        public Cell(TableCell cell) {
            cell.setFillCell(false);
            cell.addListeners(this);
        }

        @Override
        public void refresh(TableCell cell) {
            this.refresh(cell, false);
        }

        @Override
        public void refresh(TableCell cell, boolean sortOnly) {
            int sortOrder;
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
            int percentDone = 0;
            if (fileInfo2 == null) {
                sortOrder = -1;
            } else {
                long length = fileInfo2.getLength();
                if (length != 0L) {
                    percentDone = (int)(1000L * fileInfo2.getDownloaded() / length);
                }
                sortOrder = percentDone;
            }
            cell.setSortValue(sortOrder);
            if (sortOnly) {
                ProgressGraphItem.this.dispose(cell);
                return;
            }
            int newWidth = cell.getWidth();
            if (newWidth <= 0) {
                return;
            }
            int newHeight = cell.getHeight() - 2;
            int x1 = newWidth - 1 - 1;
            int y1 = newHeight - 1 - 1;
            if (x1 < 10 || y1 < 3) {
                return;
            }
            DownloadManager dm = fileInfo2 == null ? null : fileInfo2.getDownloadManager();
            DiskManager diskManager = dm == null ? null : dm.getDiskManager();
            PEPeerManager peerManager = dm == null ? null : dm.getPeerManager();
            int[] available = null;
            long unavailabilityIndicator = 0L;
            if (peerManager != null && badAvailColor != null) {
                long runningFor = SystemTime.getMonotonousTime() - peerManager.getTimeStarted(true);
                PiecePicker piece_picker = peerManager.getPiecePicker();
                float minAvail = dm.getStats().getAvailability();
                if (runningFor > 60000L && minAvail >= 0.0f && minAvail < 1.0f) {
                    DiskManagerPiece[] dmPieces = diskManager.getPieces();
                    available = piece_picker.getAvailability();
                    int firstPiece = fileInfo2.getFirstPieceNumber();
                    int lastPiece = fileInfo2.getLastPieceNumber();
                    int i = firstPiece;
                    while (i <= lastPiece) {
                        if (available[i] <= 0 && dmPieces[i].isNeeded()) {
                            unavailabilityIndicator += (long)i;
                        }
                        ++i;
                    }
                }
            }
            boolean running = diskManager != null;
            boolean hasGraphic = false;
            Graphic graphic = cell.getGraphic();
            if (graphic instanceof UISWTGraphic) {
                Image img = ((UISWTGraphic)graphic).getImage();
                boolean bl = hasGraphic = img != null && !img.isDisposed();
            }
            if (cell.isValid() && this.lastPercentDone == percentDone && this.bNoRed && running == this.was_running && unavailabilityIndicator == this.lastUnavailabilityIndicator && hasGraphic) {
                return;
            }
            this.was_running = running;
            this.lastPercentDone = percentDone;
            this.lastUnavailabilityIndicator = unavailabilityIndicator;
            Image piecesImage = null;
            if (graphic instanceof UISWTGraphic) {
                piecesImage = ((UISWTGraphic)graphic).getImage();
            }
            if (piecesImage != null && !piecesImage.isDisposed()) {
                piecesImage.dispose();
            }
            piecesImage = new Image((Device)Utils.getDisplay(), newWidth, newHeight);
            GC gcImage = new GC((Drawable)piecesImage);
            long now = SystemTime.getCurrentTime();
            if (percentDone == 1000) {
                gcImage.setForeground(Colors.blues[9]);
                gcImage.setBackground(Colors.blues[9]);
                gcImage.fillRectangle(1, 1, newWidth - 2, newHeight - 2);
            } else if (fileInfo2 != null) {
                PEPiece[] pe_pieces = peerManager == null ? null : peerManager.getPieces();
                int firstPiece = fileInfo2.getFirstPieceNumber();
                int nbPieces = fileInfo2.getNbPieces();
                if (nbPieces < 0) {
                    nbPieces = 0;
                }
                DiskManagerPiece[] dm_pieces = diskManager == null ? (dm == null ? null : dm.getDiskManagerPiecesSnapshot()) : diskManager.getPieces();
                this.bNoRed = true;
                int i = 0;
                while (i < newWidth) {
                    int a1 = (i + 1) * nbPieces / newWidth;
                    int a0 = i * nbPieces / newWidth;
                    if (a1 == a0) {
                        ++a1;
                    }
                    if (a1 > nbPieces && nbPieces != 0) {
                        a1 = nbPieces;
                    }
                    int nbAvailable = 0;
                    boolean written = false;
                    boolean partially_written = false;
                    boolean bad_avail = false;
                    if (firstPiece >= 0 && nbPieces > 0) {
                        int j = a0;
                        while (j < a1) {
                            DiskManagerPiece dm_piece;
                            int this_index = j + firstPiece;
                            if (dm_pieces != null && (dm_piece = dm_pieces[this_index]).isDone()) {
                                ++nbAvailable;
                            }
                            if (!written) {
                                boolean[] blocks;
                                PEPiece pe_piece;
                                if (available != null && available[this_index] <= 0 && dm_pieces != null && dm_pieces[this_index].isNeeded()) {
                                    bad_avail = true;
                                }
                                if (pe_pieces != null && (pe_piece = pe_pieces[this_index]) != null) {
                                    boolean bl = written = pe_piece.getLastDownloadTime(now) + 500L > this.last_draw_time;
                                }
                                if (!written && !partially_written && dm_pieces != null && (blocks = dm_pieces[this_index].getWritten()) != null) {
                                    boolean[] blArray = blocks;
                                    int n = blocks.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        boolean block = blArray[n2];
                                        if (block) {
                                            partially_written = true;
                                            break;
                                        }
                                        ++n2;
                                    }
                                }
                            }
                            ++j;
                        }
                    } else {
                        nbAvailable = 1;
                    }
                    if (bad_avail) {
                        gcImage.setBackground(badAvailColor);
                    } else {
                        gcImage.setBackground(written ? Colors.red : (partially_written ? Colors.grey : Colors.blues[nbAvailable * 9 / (a1 - a0)]));
                    }
                    gcImage.fillRectangle(i, 1, 1, newHeight - 2);
                    if (written) {
                        this.bNoRed = false;
                    }
                    ++i;
                }
            }
            gcImage.setForeground(Colors.grey);
            gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
            if (diskManager != null) {
                gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
            }
            gcImage.dispose();
            this.last_draw_time = now;
            if (cell instanceof TableCellSWT) {
                ((TableCellSWT)cell).setGraphic(piecesImage);
            } else {
                cell.setGraphic(new UISWTGraphicImpl(piecesImage));
            }
        }
    }
}

