/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.internat.MessageText;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class PriorityItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public PriorityItem() {
        super("priority", 1, -2, 70, "Files");
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        String tmp;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        int sortval = 0;
        if (fileInfo2 == null) {
            tmp = "";
        } else {
            int st = fileInfo2.getStorageType();
            if (st < 0) {
                tmp = "";
                sortval = Integer.MIN_VALUE;
            } else if ((st == 2 || st == 4) && fileInfo2.isSkipped()) {
                tmp = MessageText.getString("FileItem.delete");
                sortval = -2147483647;
            } else if (fileInfo2.isSkipped()) {
                tmp = MessageText.getString("FileItem.donotdownload");
                sortval = -2147483646;
            } else {
                int pri;
                sortval = pri = fileInfo2.getPriority();
                if (pri > 0) {
                    tmp = MessageText.getString("FileItem.high");
                    if (pri > 1) {
                        tmp = String.valueOf(tmp) + " (" + pri + ")";
                    }
                } else if (pri < 0) {
                    tmp = MessageText.getString("FileItem.low");
                    if (pri < -1) {
                        tmp = String.valueOf(tmp) + " (" + pri + ")";
                    }
                } else {
                    tmp = MessageText.getString("FileItem.normal");
                }
            }
        }
        cell.setText(tmp);
        cell.setSortValue(sortval);
    }
}

