/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.internat.MessageText;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class PiecesDoneAndCountItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public PiecesDoneAndCountItem() {
        super("piecesdoneof", 3, -1, 60, "Files");
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        int total = -1;
        int done = -1;
        if (fileInfo2 != null) {
            DiskManager dm;
            total = fileInfo2.getNbPieces();
            DiskManager diskManager = dm = fileInfo2 == null ? null : fileInfo2.getDiskManager();
            if (dm != null) {
                done = 0;
                int start = fileInfo2.getFirstPieceNumber();
                int end = start + total;
                DiskManagerPiece[] pieces = dm.getPieces();
                int i = start;
                while (i < end) {
                    if (pieces[i].isDone()) {
                        ++done;
                    }
                    ++i;
                }
            }
        }
        if (!cell.setSortValue(done) && cell.isValid()) {
            return;
        }
        cell.setText(done < 0 || total < 0 ? "" : MessageText.getString("v3.MainWindow.xofx", new String[]{String.valueOf(done), String.valueOf(total)}));
    }
}

