/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class FileETAItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private ViewUtils.CustomDateFormat cdf;
    private final MyParameterListener myParameterListener;
    private boolean eta_absolute;

    public FileETAItem() {
        super("file_eta", 2, -1, 60, "Files");
        this.setRefreshInterval(-2);
        this.myParameterListener = new MyParameterListener();
        COConfigurationManager.addWeakParameterListener(this.myParameterListener, true, "mtv.eta.show_absolute");
        this.cdf = ViewUtils.addCustomDateFormat(this);
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.myParameterListener, "mtv.eta.show_absolute");
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        long eta = -1L;
        if (fileInfo2 != null) {
            eta = fileInfo2.getETA();
        }
        if (!cell.setSortValue(eta) && cell.isValid()) {
            return;
        }
        cell.setText(this.cdf.formatETA(eta, this.eta_absolute));
    }

    @Override
    public void postConfigLoad() {
        super.postConfigLoad();
        this.cdf.update();
    }

    private class MyParameterListener
    implements ParameterListener {
        private MyParameterListener() {
        }

        @Override
        public void parameterChanged(String name) {
            FileETAItem.this.eta_absolute = COConfigurationManager.getBooleanParameter("mtv.eta.show_absolute", false);
        }
    }
}

