/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class FileAvailabilityItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private static final String zeros = "0000";
    private static final int numZeros = "0000".length();
    private int iTimesBy;

    public FileAvailabilityItem() {
        super("availability", 1, -1, 60, "Files");
        this.setRefreshInterval(-2);
        this.iTimesBy = 1;
        int i = 1;
        while (i < numZeros) {
            this.iTimesBy *= 10;
            ++i;
        }
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        String sText = "";
        DiskManagerFileInfo file = (DiskManagerFileInfo)cell.getDataSource();
        if (file == null) {
            return;
        }
        if (file.getLength() == 0L) {
            sText = "-";
            cell.setSortValue(Long.MAX_VALUE);
        } else {
            PEPeerManager pm;
            DownloadManager dm = file.getDownloadManager();
            PEPeerManager pEPeerManager = pm = dm == null ? null : dm.getPeerManager();
            if (pm != null) {
                int index = file.getIndex();
                if (index >= 0) {
                    float f = pm.getMinAvailability(index);
                    if (!cell.setSortValue((long)(f * 1000.0f)) && cell.isValid()) {
                        return;
                    }
                    sText = String.valueOf((int)(f * (float)this.iTimesBy));
                    if (numZeros - sText.length() > 0) {
                        sText = String.valueOf(zeros.substring(0, numZeros - sText.length())) + sText;
                    }
                    sText = String.valueOf(sText.substring(0, sText.length() - numZeros + 1)) + "." + sText.substring(sText.length() - numZeros + 1);
                } else {
                    cell.setSortValue(0L);
                }
            } else {
                cell.setSortValue(0L);
            }
        }
        cell.setText(sText);
    }
}

